// DiffractionImageUtility.cpp
// maintained by G.Winter
// 17th December 2003
// 
// Utility subroutines for the DiffractionImage module - things which 
// don't really belong anywhere else.
// 
// 
// 
// $Id: DiffractionImageUtility.cpp,v 1.4 2003/12/19 14:45:01 gwin Exp $

#include "DiffractionImage.h"

#include <iostream>

using namespace std;

namespace DI {
    bool machineBigEndian(void)
    {
	unsigned short a = 0xff00;
	unsigned char * ptr = (unsigned char *) &a;

	if (ptr[0] == 0xff)
	{
	    // I think that means big endian
	    return true;
	}
	else
	{
	    return false;
	}
	
	// keep compiler san happy
	return false;

    }

    // this could probably be done better inline - oh well!

    void byteSwap(unsigned short * blob)
    {
	unsigned char * ptr = (unsigned char *) blob;
	unsigned char temp;

	// I must be able to do this with masks and shifts

	temp = ptr[0];
	ptr[0] = ptr[1];
	ptr[1] = temp;
    }

    void byteSwap(unsigned int * blob)
    {
	unsigned char * ptr = (unsigned char *) blob;
	unsigned char temp;

	// I must be able to do this with masks and shifts

	temp = ptr[0];
	ptr[0] = ptr[3];
	ptr[3] = temp;

	temp = ptr[1];
	ptr[1] = ptr[2];
	ptr[2] = temp;
    }

};


