// DiffractionImageRaw.cpp
// maintained by G.Winter
// 17th December 2003
// 
// Things for handling the raw images in the DiffractionImage module - 
// which could be pretty useful I guess... would make extending
// the image handling a bit easier - take the XDS approach!
// 
// 
// $Id: DiffractionImageRaw.cpp,v 1.1 2003/12/17 12:23:53 gwin Exp $

#include "DiffractionImage.h"

#include <iostream>
#include <fstream>

// assert - for debugging mode

#ifdef TEST_CODE
#define NDEBUG
#include <assert.h>
#endif

// things for "C"

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

using namespace std;

namespace DI 
{
    void DiffractionImage::allocateImage(void)
    {
	// allocate the image, trapping errors as we go

	if ((width <= 0) ||
	    (height <= 0))
	{
	    throw(DiffractionImageException("bad size"));
	}

	if (image != NULL)
	{
	    // free the image before we restart
	    delete [] image;
	    image = NULL;
	}

	image = new unsigned short[width * height];

	if (image == NULL)
	{
	    throw(DiffractionImageException("error allocating image"));
	}
    }


    void DiffractionImage::loadRawImage(string filename,
					int offset)
    {

	// then open the image
	int fd = open(filename.c_str(), O_RDONLY);

	if (fd < 0)
	{
	    throw(DiffractionImageException("error opening raw image"));
	}
	
	// then advance - unfortunately this can only be performed 
	// by reading :o( however, we can read this into the originalHeader
	// entry in the class

	int amount = read(fd, originalHeader, offset);

	if (amount != offset)
	{
	    close(fd);
	    throw(DiffractionImageException("error reading header"));
	}

	// now read the image
	if (image == NULL)
	{
	    // allocate it
	    image = new unsigned short [width * height];

	}

	if (image == NULL)
	{
	    close(fd);
	    throw(DiffractionImageException("error allocating image"));
	}

	amount = read(fd, (unsigned char *) image, width * height * 2);
	// that should be the "big read" so
	close(fd);
	
	if (amount < width * height * 2)
	{
	    throw(DiffractionImageException("error reading raw image"));
	}

	if ((bigEndian && machineBigEndian()) ||
	    (!bigEndian && !machineBigEndian()))
	{
	    // do nothing
	}
	else
	{
	    // byte swap - this shouldn't be implemented as a 
	    // function call as that will be very expensive - perhaps
	    // there is a clever way to perform a byte swap
	    // using something like 
	    // a = ((a & 0xff00) >> 8) & ((a & 0x00ff) << 8);
	    for (int i = 0; i < width * height; i++)
	    {
		byteSwap(&(image[i]));
	    }
	}

	close(fd);

    }
};
