// DiffractionImageMAR.cpp
// maintained by G.Winter
// 10th June 2004
// 
// A method based on the marcvt application for reading all MAR research
// image formats, including image plates and CCD's.
// 
// This relies on marcvt in third_party. You have been warned!
// 
// 
// 
// $Id: DiffractionImageMAR.cpp,v 1.3 2005/11/22 13:38:14 svensson Exp $


// C++ things
#include <iostream>
#include <fstream>
#include <map>

// core C things - required for using open() and read() below
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

extern "C" {
  // include the header file descriptions
#include "../../../third_party/MAR/marcvt/io/mar300_header.h"
#include "../../../third_party/MAR/marcvt/io/mar345_header.h"
#include "../../../third_party/MAR/marcvt/io/marccd_header.h"
#include "../../../third_party/MAR/marcvt/io/marcif_header.h"
  
  // this returns a type defined in marcvt.h
#include "../../../third_party/MAR/marcvt/marcvt/marcvt.h"

  int is_mar(char * filename);
  extern void swaplong(void * data, int size);
  extern int GetCIFHeader(char * program, char * filename, FILE * file);
  extern MAR345_HEADER Getmar345Header(FILE * file);
  extern MAR300_HEADER Getmar300Header(FILE * file);
  extern MAR345_HEADER CIF2mar345Header(char * filename);
  extern int get_pck(FILE * file, unsigned short * data);
  extern void Work(void);
}

#include "DiffractionImage.h"

using namespace std;

namespace DI
{

  void DiffractionImage::loadMAR(string filename)
  {
    loadMARHeader(filename);
    allocateImage();
    FILE * file = fopen(filename.c_str(), "r");
    get_pck(file, image);
    fclose(file);
  }

  // this routine is based (very closely!) around 
  // mar_convert from the marcvt application
  //
  // http://www.marresearch.com/download.htm

  void DiffractionImage::loadMARHeader(string filename)
  {
    MAR345_HEADER h345;
    MARCCD_HEADER hccd;

    int swap = 0;
    int type = is_mar((char *) filename.c_str());

    FILE * file;

    file = fopen(filename.c_str(), "r");

    if (file == NULL)
      {
	throw(DiffractionImageException("Error opening file " + filename));
      }

    switch(type)
      {
      case NONE:
	throw(DiffractionImageException("No image " + filename));
	break;
      case CCD:
	// read the CCD image header
	fseek(file, 1024, SEEK_SET);
	if (fread(&hccd, sizeof(MARCCD_HEADER), 1, file) < 1)
	  {
	    fclose(file);
	    throw(DiffractionImageException("Error reading Mar CCD " 
					    "image header"));
	  }

	if (hccd.header_byte_order < 1234 ||
	    hccd.header_byte_order > 4321)
	  {
	    swaplong((void *) &hccd, sizeof(MARCCD_HEADER));
	  }

	if (hccd.header_byte_order < 1234 ||
	    hccd.header_byte_order > 4321)
	  {
	    fclose(file);
	    throw(DiffractionImageException("Error byte swapping CCD header"));
	  }

	// determine if the image need be byte swapped
#if (__linux || VMS || __ALPHA || _osf__)
	if (hccd.data_byte_order == 1234)
	  {
	    swap = 1;
	  }
#elif (__sgi || SUN || __hpux)
	if (hccd.data_byte_order == 4321)
	  {
	    swap = 1;
	  }
#endif

	// now get the information out of the header
	width = hccd.nfast;
	height = hccd.nslow;

	beamX = 0.001 * hccd.beam_x;
	beamY = 0.001 * hccd.beam_y;
	distance = 0.001 * hccd.xtal_to_detector;
	exposureTime = 0.001 * hccd.exposure_time;
	phiStart = 0.001 * hccd.start_phi;
	phiEnd = 0.001 * hccd.end_phi;

	pixelX = 0.001 * hccd.pixelsize_x;
	pixelY = 0.001 * hccd.pixelsize_y;

	wavelength = 0.000001 * hccd.source_wavelength;

	fclose(file);

	break;
      case MAR345:
	// read a MAR 345 image header
	h345 = Getmar345Header(file);

	// next get the bits out of the MAR 345 header
	width = h345.size;
	height = h345.size;
	beamX = h345.xcen;
	beamY = h345.ycen;
	distance = h345.dist;
	exposureTime = h345.time;
	phiStart = h345.phibeg;
	phiEnd = h345.phiend;
	// I want these in mm
	pixelX = 0.001 * h345.pixel_length;
	pixelY = 0.001 * h345.pixel_height;

	wavelength = h345.wave;

	fclose(file);

	break;

	// could add support for MAR 300 image plates here too...

      default:
	throw(DiffractionImageException("Unrecognised image type"));
      }

  }
};

