// DiffractionImageCompare.cpp
// maintained by G.Winter
// 8th November 2004
// 
// A set of routines for performing pixel-wise calculations between two 
// images - this image and the other image.
// 
// void min(const DiffractionImage & other);
// void max(const DiffractionImage & other);
// void diff(const DiffractionImage & other);
// void sum(const DiffractionImage & other);
// 
// $Id: DiffractionImageCompare.cpp,v 1.3 2005/11/22 13:38:14 svensson Exp $


#include "DiffractionImage.h"
#include <iostream>
#include <fstream>
#include <string>
#include <vector>

namespace DI
{
  void DiffractionImage::min(DiffractionImage & other)
  {
    unsigned short * other_image;

    if (image == NULL)
      {
	throw (DiffractionImageException("NULL image (this)"));
      }

    if (width != other.getWidth())
      {
	throw (DiffractionImageException("Images different width"));
      }

    if (height != other.getHeight())
      {
	throw (DiffractionImageException("Images different height"));
      }

    other_image = other.getImage();

    if (other_image == NULL)
      {
	throw(DiffractionImageException("NULL image (other)"));
      }

    for (int i = 0; i < width * height; i++)
      {
	if (other_image[i] < image[i])
	  {
	    image[i] = other_image[i];
	  }
      }

  }

  void DiffractionImage::max(DiffractionImage & other)
  {
  }

  void DiffractionImage::diff(DiffractionImage & other)
  {
  }

  void DiffractionImage::sum(DiffractionImage & other)
  {
  }
};
