// DiffractionImageCalculations.cpp
// maintained by G.Winter
// 7th June 2004
// 
// The implementation of functionality for performing calculations with 
// the DiffractionImages. At the moment the following functions are 
// implemented:
// float[17] radial(void)
// int[17] histogram(void)
// $Id: DiffractionImageCalculations.cpp,v 1.4 2004/09/06 15:32:58 gwin Exp $

#include "DiffractionImage.h"
#include <iostream>
#include <fstream>
#include <string>
#include <vector>

namespace DI
{
  vector<int> DiffractionImage::histogram(void)
  {
    vector<int> results;

    for (int i = 0; i < 17; i++)
      {
	results.push_back(0);
      }

    int width = getWidth();
    int height = getHeight();

    unsigned short pixel;

    for (int i = 0; i < width * height; i++)
      {
	pixel = image[i];
	
	if (pixel & 0x8000)
	  {
	    results[16] ++;
	  }
	else if (pixel & 0x4000)
	  {
	    results[15] ++;
	  }
	else if (pixel & 0x2000)
	  {
	    results[14] ++;
	  }
	else if (pixel & 0x1000)
	  {
	    results[13] ++;
	  }
	else if (pixel & 0x0800)
	  {
	    results[12] ++;
	  }
	else if (pixel & 0x0400)
	  {
	    results[11] ++;
	  }
	else if (pixel & 0x0200)
	  {
	    results[10] ++;
	  }
	else if (pixel & 0x0100)
	  {
	    results[9] ++;
	  }
	else if (pixel & 0x0080)
	  {
	    results[8] ++;
	  }
	else if (pixel & 0x0040)
	  {
	    results[7] ++;
	  }
	else if (pixel & 0x0020)
	  {
	    results[6] ++;
	  }
	else if (pixel & 0x0010)
	  {
	    results[5] ++;
	  }
	else if (pixel & 0x0008)
	  {
	    results[4] ++;
	  }
	else if (pixel & 0x0004)
	  {
	    results[3] ++;
	  }
	else if (pixel & 0x0002)
	  {
	    results[2] ++;
	  }
	else if (pixel & 0x0001)
	  {
	    results[1] ++;
	  }
	else
	  {
	    results[0] ++;
	  }
      }

    return results;
  }

  vector<float> DiffractionImage::radial(void)
  {
    return radial(16);
  }

  vector<float> DiffractionImage::radial(int bins)
  {
    vector<float> results;
    vector<float> totals;
    vector<int> counts;

    float dr, r;

    for (int i = 0; i < bins + 1; i++)
      {
	totals.push_back(0.0);
	counts.push_back(0);
	results.push_back(0.0);
      }

    int width = getWidth();
    int height = getHeight();
    unsigned short pixel;

    int bin;
    
    dr = 0.5 * float(width) / float(bins);
    for (int i = 0; i < height; i++)
      {
	for (int j = 0; j < width; j++)
	  {
	    pixel = image[i * width + j];

	    r = sqrt((i - 0.5 * height) * (i - 0.5 * height) + 
		     (j - 0.5 * width) * (j - 0.5 * width));

	    bin = int(r / dr);

	    if (bin < bins)
	      {
		totals[bin] += pixel;
		counts[bin] ++;
	      }
	    else
	      {
		totals[bins] += pixel;
		counts[bins] ++;
	      }
	  }
      }

    for (int i = 0; i < bins + 1; i++)
      {
	if (counts[i] != 0)
	  {
	    results[i] = totals[i] / counts[i];
	  }
	else
	  {
	    results[i] = 0;
	  }
      }

    return results;
  }

  // calculate how asymmetric the image is

  vector<float> DiffractionImage::asymmetry(void)
  {
    vector<float> results;
    double theta;
    double x, y;

    int width = getWidth();
    int height = getHeight();

    for (int i = 0; i < 18; i++)
      {
	results.push_back(0.0);
      }

    for (int i = 0; i < 18; i++)
      {
	theta = ((double) i) * 4.0 * atan(1.0) / 18.0;
	x = cos(theta);
	y = sin(theta);
	double total_plus = 0;
	double total_minus = 0;

	for (int _i = 0; _i < height; _i ++)
	  {
	    int dy = _i - (height / 2);
	    for (int _j = 0; _j < width; _j ++)
	      {
		int dx = _j - (width / 2);
		double dot = dx * x + dy * y;
		if (dot > 0)
		  {
		    total_plus += image[_i * width + _j];
		  }
		else
		  {
		    total_minus += image[_i * width + _j];
		  }
	      }
	  }
	results[i] = (total_plus - total_minus) / (total_plus + total_minus);
      }

    return results;
  }

};



    
