// DiffractionImage.h
// maintained by G.Winter
// 15th December 2003
// 
// A replacement for the old DiffractionImage library - with one 
// of the same name and a very similar API. Take care though - this one 
// will be different!
// 
// 
// $Id: DiffractionImage.h,v 1.21 2005/11/22 13:38:14 svensson Exp $

// switch on the GSL stuff
#define INCLUDE_GSL


#ifndef DIFFRACTIONIMAGE_HEADER
#define DIFFRACTIONIMAGE_HEADER

#include <iostream>
#include <fstream>
#include <string>
#include <vector>

// include helpful things from the standard namespace
// like cout and cerr.

using namespace std;

#ifdef INCLUDE_PYTHON
#include "Python.h"
#endif

namespace DI 
{

    class DiffractionImage 
      {
      public:
	// if we're including Python functionality then 

	// public constructors and destructors
	DiffractionImage(void);             // done
	DiffractionImage(string filename);  // done
	~DiffractionImage(void);            // done
	
	// constructors and destructors, volume II - this
	// time they are real constructors etc, which the above
	// will call - this enables the code for Python objects
	// share the same constructors etc without duplicating 
	// code

	// the destructor will re-initialise the structure, so this
	// could be used for resetting

	void constructor(void);            // done
	void constructor(string filename); // done
	void destructor(void);             // done

	// next the get & set methods - these should be generated 
	// and not hand coded, but I can't be bothered.

	// note well - I am trying with this to not be fussy - 
	// so I will avoid unsigned, const and references where
	// possible

	// these should be defined via macro to save typing!
	// never mind.. setter methods should also be available
	// to allow external functions to be able to read and assign 
	// images.

	// all done

	int getWidth(void);
	int getHeight(void);

	float getBeamX(void);
	float getBeamY(void);

	float getWavelength(void);
	float getDistance(void);

	float getTwoTheta(void);
	float getPhiStart(void);
	float getPhiEnd(void);
	
	float getPixelX(void);
	float getPixelY(void);

	float getExposureTime(void);

	bool getWarning();
	string getMessage();

	// setter methods for the same data

	void setBeamX(float);
	void setBeamY(float);

	void setWavelength(float);
	void setDistance(float);

	void setTwoTheta(float);
	void setPhiStart(float);
	void setPhiEnd(float);
	
	void setPixelX(float);
	void setPixelY(float);

	void setExposureTime(float);

	// get a pointer to the image - and use with great care!
	// the image will be stored as an unsigned short, as this 
	// seems to be the common storage type

	unsigned short * getImage(void);
	
	// methods to write the image out as a jpeg
	// these are void and so will raise an exception
	// in the event of an error

	// by default this will produce a JPEG image with quality
	// 85 (good enough) and size somewhere around 1k x 1k.

	// these are done

	void jpeg(string filename);
	void jpeg(string filename,
		  int quality);
	void jpeg(string filename,
		  int quality,
		  int zoom);
	
	// if optimise == true then do floating point, 
	// else just shift bits

	void jpeg(string filename,
		  int quality,
		  int zoom,
		  bool optmise);


	// array subscription operators
	// by design these MUST return references

	// done

	unsigned short & operator[] (int offset);
	
	// copy constructors & etc - likewise require references

	DiffractionImage & operator= (DiffractionImage & otherImage);

	// some routines for comparing images - min, max, diff, sum
	// will alter THIS image
	void min(DiffractionImage & other);
	void max(DiffractionImage & other);
	void diff(DiffractionImage & other);
	void sum(DiffractionImage & other);
	
	// next - reading and writing methods - these depend in some values
	// defined in the header struture of the images

	// redefine this to return a string bearing the image type
	// will return one of "adsc", "marccd" and "mar" at the moment
	string load(string filename);
	void load(string filename,
		  string format);
	string loadHeader(string filename);
	void loadHeader(string filename,
			string format);
	// this will assume that the image and header are called
	// imageName + .jp2, imageName.hdr respectively
	void loadCompressed(string imageName);
	void loadCompressed(string headerFileName,
			    string imageFileName);
	// this will JUST read the jp2 image - DO NOT USE ALONE
	void loadCompressedImage(string imageName);

#ifdef WRITE_DONE

	// generic writer methods

	void save(string filename);
	void saveHeader(string filename);
	void saveCompressed(string filename);
	void saveCompressed(string headerFileName,
			    string imageFileName);
	// this will just write out the image and no header - DO NOT USE
	void saveCompressedImage(string filename);

#endif

	// this one is ambitious! I want to allow header editing - but 
	// this should not promise to retain all of the info in the header.

	void regenerateHeader(void);

	// specific methods to read these

	// allocate the image according to the information in the
	// image header

	void allocateImage(void);

	void loadRawImage(string filename,
			  int offset);

	void loadADSC(string filename);
	void loadMarCCD(string filename);
	void loadMAR(string filename);

	
	void loadADSCHeader(string filename);
	void loadMarCCDHeader(string filename);
	void loadMARHeader(string filename);

	void saveADSC(string filename);
	void saveMarCCD(string filename);

	// this is all of the complex methods

	friend ostream & operator<< (ostream & out,
				     DiffractionImage & d);


	// calculations you can do with a DiffractionImage

	vector<int> histogram(void);
	vector<float> radial(void);
	vector<float> radial(int bins);
	vector<float> asymmetry(void);


    private:
	
	// this is the real data which represents my image structure
	// I have yet to meet a header > 4k

	unsigned char originalHeader[4096];
	int originalHeaderLength;

	// this will be true if the original image was big endian
	bool bigEndian;

	// the basic image size

	int width;
	int height;

	float beamX;
	float beamY;

	float distance;
	float wavelength;
	float twoTheta;
	float phiStart;
	float phiEnd;
	float pixelX;
	float pixelY;

	// a way of communicating between the image loading
	// expertise and the outside world!
	bool warning;
	string message;

	float exposureTime; // in seconds

	unsigned short * image;

    };

    class DiffractionImageException {
    public:
	DiffractionImageException(void);
	DiffractionImageException(string newMessage);
	~DiffractionImageException(void);
	
	string getMessage(void);

    private:

	string message;
    };
    
    // other random functions

    // this will use the following
    // guessFormat will return either 
    // "adsc", "marccd", "unknown"
    
    // first two bytes are 4949 (HEX) for mccd and 0a7b
    // for ADSC. this should be enough to guess the format.
    // Mar 225 fits with mccd.
    // 0a7b = {\n? :o)
    
    string guessFormat(string filename);

    void enlargeImage(unsigned short * original,
		      int width,
		      int height,
		      int zoom,
		      unsigned short * copy); // this must be allocated

    void reduceImage(unsigned short * original,
		     int width,
		     int height,
		     int zoom,
		     unsigned short * copy); // this must be allocated

    // this one will also do the downsampling to eight bit depth
    // if optimise then perform some optimisation i.e. looking at the
    // spread of values else just / 256

    void downSample(unsigned short * original,
		    int width,
		    int height,
		    bool optimise,
		    unsigned char * copy);

    void invertImage(unsigned char * image,
		     int width,
		     int height);

    // this will include the downsampling and the image
    // inversion

    void writeJpegImage(unsigned short * image,
			int width,
			int height,
			int quality,
			bool optimise,
			const char * filename);

    // some utility routines - these are defined in 
    // DiffractionImageUtility.cpp as functions

    bool machineBigEndian(void);
    void byteSwap(unsigned short * blob);
    void byteSwap(unsigned int * blob);

#ifdef INCLUDE_PYTHON
    class PyDiffractionImage
      {
      public:
	PyObject_HEAD;
	DiffractionImage diffractionImage;
	PyDiffractionImage(void);
	PyDiffractionImage(string filename);
	~PyDiffractionImage(void);
      };
	  
#endif


};







#endif
