##############################################################################
#
#   File:      dr_.py
#
#   Project:   DataRanking Project
#
#   Author(s): Romeu A. Pieritz [pieritz@esrf.fr]
#              Olof Svensson [svensson@esrf.fr]
#
#   Date:      2005/06/24
#
#   License:
#   --------------------------------------------------------------------------
#   Data Ranking Project Project
#   Copyright (c) 2005, Data Ranking Project developers (see above AUTHORS)
#   All rights reserved.
#
#   Redistribution and use in source and binary forms, with or without
#   modification, are permitted provided that the following conditions
#   are met:
#
#   Redistributions of source code must retain the above copyright notice,
#   this list of conditions and the following disclaimer.
#
#   Redistributions in binary form must reproduce the above copyright notice,
#   this list of conditions and the following disclaimer in the documentation
#   and/or other materials provided with the distribution.
#
#   Neither the names of DataRanking's copyright owner nor the names of its
#   contributors may be used to endorse or promote products derived from
#   this software without specific prior written permission.
#
#   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
#   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
#   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
#   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
#   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
#   TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
#   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
#   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
#   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
#   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
##############################################################################


from dr_system      import *
from dr_kernel      import DRVerbose
from dr_crystal     import DRCrystal


class DRProject( DRList ):
    
    def __init__( self, _odrProject = None ):
        DRList.__init__( self )
        self.m_odrEngineType = DRToken( "DREngine" )
        self.m_bisValidProject = True
        
        if _odrProject is not None:
            self.setEngineType( _odrProject.getEngineType() )
            self.m_bisValidProject = _odrProject.testIntegrity()
            for i in _odrProject:
                self.append( i.duplicate() )

        
    def setEngineType( self, _odrEngineType ):
        self.m_odrEngineType = DRToken( _odrEngineType )
        
        
    def getEngineType( self ):
        return DRToken( self.m_odrEngineType )
        

    def addCrystal( self, _odrCrystal ):
        if _odrCrystal is None:
            return
        self.append( _odrCrystal.duplicate() )
        
        
    def addProject( self, _odrProject ):
        if _odrProject is not None:
            for i in _odrProject :
                self.append( i.duplicate() )
        
        
    def outputScreen( self ):
        DRVerbose.screen( "Project:: " + DRString( self.getName() ) )
        DRVerbose.screen( "ProjectEngine:: " + DRString( self.getEngineType() ) )
        ielem = 0
        for i in self:
            i.outputScreen( ielem )
            ielem += 1


    def testIntegrity( self ):
        return self.m_bisValidProject

       
    def setRank( self, _odrStringInfo = DRString( "Ranking Ok - DNA BioXHIT Compatibility Prototype Version" )):
        rank = 0;
        for crystal in self:
            rank = rank + 1
            crystal.setRank( rank )
            crystal.setRankEngine( DRString( self.getEngineType() ) )
            crystal.setRankInformation( DRString( _odrStringInfo ) )
                


    # DNA BioXHIT Compatibility Layer ########################################
    def importXmlDna( self, _odrString ):
        odrXml = DRXml()
        odrXml.input( DRString( _odrString ) )
        odrXmlElement = odrXml.getElement( self.getMagicNumber() )
        if (odrXmlElement!=None):
            self.inputXmlDna( odrXmlElement )
            self.m_bisValidProject = True
        else:
            self.m_bisValidProject = False
        odrXml.destroy()
    
 
    def exportXmlDna( self, _odrString ):
        odrXml = DRXml( "dataRankProjectDNA" )
        odrXml.addComment( "# Asynchronous Action Library Project" )
        odrXml.addComment( "# Version   :: " + DRString( "0.9" ))
        odrXml.addComment( "# Date      :: " + DRTime.timeString())          
        odrXml.addComment( "# DNA BioXHIT Compatible XML file" )
        self.outputXmlDna( odrXml, odrXml.rootNode() )
        odrXml.output( DRString( _odrString ) )
        odrXml.destroy()
        
        

    def inputXmlDna( self, _odrXmlElement ):
        self.inputXmlObject( _odrXmlElement )
        iobjListXmlElement = DRXml.getElementListObject( _odrXmlElement, "dataCrystal" )
        if (iobjListXmlElement!=None):
            for iElement in iobjListXmlElement:
                odrCrystal = DRCrystal()
                odrCrystal.inputXmlDna( iElement )
                self.append( odrCrystal )
                
 
 
    def outputXmlDna( self, _odrXml, _odrXmlElement ):
        odrXmlElement = self.outputXmlObject( _odrXml, _odrXmlElement ) 
        for i in self:
            i.outputXmlDna( _odrXml, odrXmlElement, True )
            
 

##############################################################################
