##############################################################################
#
#   File:      dr_.py
#
#   Project:   DataRanking Project
#
#   Author(s): Romeu A. Pieritz [pieritz@esrf.fr]
#              Olof Svensson [svensson@esrf.fr]
#
#   Date:      2005/06/24
#
#   License:
#   --------------------------------------------------------------------------
#   Data Ranking Project Project
#   Copyright (c) 2005, Data Ranking Project developers (see above AUTHORS)
#   All rights reserved.
#
#   Redistribution and use in source and binary forms, with or without
#   modification, are permitted provided that the following conditions
#   are met:
#
#   Redistributions of source code must retain the above copyright notice,
#   this list of conditions and the following disclaimer.
#
#   Redistributions in binary form must reproduce the above copyright notice,
#   this list of conditions and the following disclaimer in the documentation
#   and/or other materials provided with the distribution.
#
#   Neither the names of DataRanking's copyright owner nor the names of its
#   contributors may be used to endorse or promote products derived from
#   this software without specific prior written permission.
#
#   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
#   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
#   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
#   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
#   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
#   TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
#   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
#   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
#   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
#   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
##############################################################################


from dr_definition                  import *
from dr_kernel                      import DRVerbose
from dr_system                      import DRToken
from dr_system                      import DRString
from dr_system                      import DRList
from dr_system                      import DRXml
from dr_system                      import DRDict
from dr_dna                         import DRDna


class DRDnaScreeningOutputLattice( DRDna ):
    
    def __init__( self ):
        DRDna.__init__( self )     
        self.m_spaceGroup               = None
        self.m_pointGroup               = None
        self.m_bravaisLattice           = None
        self.m_rawOrientationMatrix_a_x = None
        self.m_rawOrientationMatrix_a_y = None
        self.m_rawOrientationMatrix_a_z = None
        self.m_rawOrientationMatrix_b_x = None
        self.m_rawOrientationMatrix_b_y = None
        self.m_rawOrientationMatrix_b_z = None
        self.m_rawOrientationMatrix_c_x = None
        self.m_rawOrientationMatrix_c_y = None
        self.m_rawOrientationMatrix_c_z = None
        self.m_unitCell_a               = None
        self.m_unitCell_b               = None
        self.m_unitCell_c               = None
        self.m_unitCell_alpha           = None
        self.m_unitCell_beta            = None
        self.m_unitCell_gamma           = None
        self.m_screeningOutputLatticeId = None #"xsd:integer"/>
        self.m_screeningOutputId        = None #"xsd:integer"/>
        self.m_timeStamp                = None #"xsd:string"
                   
#    
#  <xsd:complexType name="ScreeningOutputLattice">
#    <xsd:sequence>
#      <xsd:element name="screeningOutputLatticeId"
#                   minOccurs="0"
#                   maxOccurs="1"
#                   type="xsd:integer"/>
#      <xsd:element name="screeningOutputId"
#                   minOccurs="0"
#                   maxOccurs="1"
#                   type="xsd:integer"/>
#      <xsd:element name="spaceGroup"
#                   minOccurs="0"
#                   maxOccurs="1"
#                   type="xsd:string"/>
#      <xsd:element name="pointGroup"
#                   minOccurs="0"
#                   maxOccurs="1"
#                   type="xsd:string"/>
#      <xsd:element name="bravaisLattice"
#                   minOccurs="0"
#                   maxOccurs="1"
#                   type="xsd:string"/>
#      <xsd:element name="rawOrientationMatrix_a_x"
#                   minOccurs="0"
#                   maxOccurs="1"
#                   type="xsd:double"/>
#      <xsd:element name="rawOrientationMatrix_a_y"
#                   minOccurs="0"
#                   maxOccurs="1"
#                   type="xsd:double"/>
#      <xsd:element name="rawOrientationMatrix_a_z"
#                   minOccurs="0"
#                   maxOccurs="1"
#                   type="xsd:double"/>
#      <xsd:element name="rawOrientationMatrix_b_x"
#                   minOccurs="0"
#                   maxOccurs="1"
#                   type="xsd:double"/>
#      <xsd:element name="rawOrientationMatrix_b_y"
#                   minOccurs="0"
#                   maxOccurs="1"
#                   type="xsd:double"/>
#      <xsd:element name="rawOrientationMatrix_b_z"
#                   minOccurs="0"
#                   maxOccurs="1"
#                   type="xsd:double"/>
#      <xsd:element name="rawOrientationMatrix_c_x"
#                   minOccurs="0"
#                   maxOccurs="1"
#                   type="xsd:double"/>
#      <xsd:element name="rawOrientationMatrix_c_y"
#                   minOccurs="0"
#                   maxOccurs="1"
#                   type="xsd:double"/>
#      <xsd:element name="rawOrientationMatrix_c_z"
#                   minOccurs="0"
#                   maxOccurs="1"
#                   type="xsd:double"/>
#      <xsd:element name="unitCell_a"
#                   minOccurs="0"
#                   maxOccurs="1"
#                   type="xsd:double"/>
#      <xsd:element name="unitCell_b"
#                   minOccurs="0"
#                   maxOccurs="1"
#                   type="xsd:double"/>
#      <xsd:element name="unitCell_c"
#                   minOccurs="0"
#                   maxOccurs="1"
#                   type="xsd:double"/>
#      <xsd:element name="unitCell_alpha"
#                   minOccurs="0"
#                   maxOccurs="1"
#                   type="xsd:double"/>
#      <xsd:element name="unitCell_beta"
#                   minOccurs="0"
#                   maxOccurs="1"
#                   type="xsd:double"/>
#      <xsd:element name="unitCell_gamma"
#                   minOccurs="0"
#                   maxOccurs="1"
#                   type="xsd:double"/>
#      <xsd:element name="timeStamp"
#                   minOccurs="0"
#                   maxOccurs="1"
#                   type="xsd:string"/>
#    </xsd:sequence>
#  </xsd:complexType>

      

  
    def inputXmlDna( self,  _odrXmlElement ): 
        for ikey in self.__dict__:
            odrValue = DRXml.getElementTokenValue( _odrXmlElement, DRXml.getAtributeToken( ikey ) )
            if (odrValue!=None):
                if ( ikey==DRToken( "m_spaceGroup" ) or ikey==DRToken( "m_pointGroup" ) or ikey==DRToken( "m_bravaisLattice" ) ):
                    self.__dict__[ ikey ] = odrValue
                elif ( ikey==DRToken( "m_screeningOutputLatticeId" ) or ikey==DRToken( "m_screeningOutputId" )  ):
                    self.__dict__[ ikey ] = odrValue.atoi()
                else:
                    self.__dict__[ ikey ] = odrValue.atof()
            

    def outputXmlDna( self, _odrXml, _odrXmlElement ):
        odrXmlElementObject = _odrXml.createElement( "ScreeningOutputLattice" ) # Also substitute by the __dict__ access scheme
        _odrXmlElement.appendChild( odrXmlElementObject )

        for ikey in self.__dict__:
            if ( ikey!=DRToken( "m_objectName" ) and ikey!=DRToken( "m_objectVersion" ) ):
                if ( ikey!=DRToken( "m_objectID" ) and ikey!=DRToken( "m_objectMagicNumber" ) ):
                    if ( self.__dict__[ ikey ]!= None ):         
                        odrXmlElement = _odrXml.createElement( DRXml.getAtributeToken( ikey ) )
                        odrXmlElement.appendChild( _odrXml.createTextNode( DRString( self.__dict__[ ikey ] ) ) )      
                        odrXmlElementObject.appendChild( odrXmlElement )
                
                
##############################################################################
