##############################################################################
#
#   File:      dr_.py
#
#   Project:   DataRanking Project
#
#   Author(s): Romeu A. Pieritz [pieritz@esrf.fr]
#              Olof Svensson [svensson@esrf.fr]
#
#   Date:      2005/06/24
#
#   License:
#   --------------------------------------------------------------------------
#   Data Ranking Project Project
#   Copyright (c) 2005, Data Ranking Project developers (see above AUTHORS)
#   All rights reserved.
#
#   Redistribution and use in source and binary forms, with or without
#   modification, are permitted provided that the following conditions
#   are met:
#
#   Redistributions of source code must retain the above copyright notice,
#   this list of conditions and the following disclaimer.
#
#   Redistributions in binary form must reproduce the above copyright notice,
#   this list of conditions and the following disclaimer in the documentation
#   and/or other materials provided with the distribution.
#
#   Neither the names of DataRanking's copyright owner nor the names of its
#   contributors may be used to endorse or promote products derived from
#   this software without specific prior written permission.
#
#   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
#   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
#   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
#   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
#   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
#   TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
#   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
#   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
#   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
#   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
##############################################################################


from dr_definition                  import *
from dr_kernel                      import DRVerbose
from dr_system                      import DRToken
from dr_system                      import DRString
from dr_system                      import DRList
from dr_system                      import DRXml
from dr_dna                         import DRDna


class DRDnaScreeningOutput( DRDna ):
    
    def __init__( self ):
        DRDna.__init__( self )
        self.m_rejectedReflections  = None
        self.m_resolutionObtained   = None
        self.m_spotDeviationR       = None
        self.m_beamShiftX           = None
        self.m_beamShiftY           = None
        self.m_numSpotsFound        = None
        self.m_numSpotsUsed         = None
        self.m_numSpotsRejected     = None
        self.m_mosaicity            = None
        self.m_diffractionRings     = None #type="xsd:boolean"/>
        self.m_screeningOutputId    = None #"xsd:integer"/>
        self.m_screeningId          = None #"xsd:integer"/>
        self.m_statusDescription    = None #"xsd:string"/>
        self.m_spotDeviationTheta   = None #"xsd:double"/>
  
 
 
#<xsd:complexType name="ScreeningOutput">
#    <xsd:sequence>
#      <xsd:element name="screeningOutputId"
#                   type="xsd:integer"/>
#      <xsd:element name="screeningId"
#                   type="xsd:integer"/>
#      <xsd:element name="statusDescription"
#                   type="xsd:string"/>
#      <xsd:element name="rejectedReflections"
#                   type="xsd:integer"/>
#      <xsd:element name="resolutionObtained"
#                   type="xsd:double"/>
#      <xsd:element name="spotDeviationR"
#                   type="xsd:double"/>
#      <xsd:element name="spotDeviationTheta"
#                   type="xsd:double"/>
#      <xsd:element name="beamShiftX"
#                   type="xsd:double"/>
#      <xsd:element name="beamShiftY"
#                   type="xsd:double"/>
#      <xsd:element name="numSpotsFound"
#                   type="xsd:integer"/>
#      <xsd:element name="numSpotsUsed"
#                   type="xsd:integer"/>
#      <xsd:element name="numSpotsRejected"
#                   type="xsd:integer"/>
#      <xsd:element name="mosaicity"
#                   type="xsd:double"/>
#      <xsd:element name="diffractionRings"
#                   type="xsd:boolean"/>
#
#  

 
 
    # Interface to setup values
    def setResolutionObtained( self, _fResolution ):
        self.m_resolutionObtained = (float)( _fResolution )
    def getResolutionObtained( self ):
        return self.m_resolutionObtained
    
    
    def inputXmlDna( self,  _odrXmlElement ): 
        for ikey in self.__dict__:
            odrValue = DRXml.getElementTokenValue( _odrXmlElement, DRXml.getAtributeToken(  ikey ) )
            if (odrValue!=None):
                if ( ikey==DRToken( "m_numSpotsRejected" ) or ikey==DRToken( "m_screeningOutputId" ) or ikey==DRToken( "m_screeningId" ) or ikey==DRToken( "m_rejectedReflections" ) or ikey==DRToken( "m_numSpotsFound" ) or ikey==DRToken( "m_numSpotsUsed" ) ):
                    self.__dict__[ ikey ] = odrValue.atoi()
                elif ( ikey==DRToken( "m_diffractionRings" ) ):
                    if odrValue=="True" :
                        self.__dict__[ ikey ] = True
                    else:
                        self.__dict__[ ikey ] = False   
                elif ( ikey==DRToken( "m_statusDescription" ) ):
                    self.__dict__[ ikey ] = odrValue
                else:
                    self.__dict__[ ikey ] = odrValue.atof()
            

    def outputXmlDna( self, _odrXml, _odrXmlElement ):
        odrXmlElementObject = _odrXml.createElement( "ScreeningOutput" ) 
        _odrXmlElement.appendChild( odrXmlElementObject )
        for ikey in self.__dict__:
            if ( ikey!=DRToken( "m_objectName" ) and ikey!=DRToken( "m_objectVersion" ) ):
                if ( ikey!=DRToken( "m_objectID" ) and ikey!=DRToken( "m_objectMagicNumber" ) ):
                    if ( self.__dict__[ ikey ]!= None ):         
                        odrXmlElement = _odrXml.createElement( DRXml.getAtributeToken( ikey ) )
                        odrXmlElement.appendChild( _odrXml.createTextNode( DRString( self.__dict__[ ikey ] ) ) )      
                        odrXmlElementObject.appendChild( odrXmlElement )
                

##############################################################################

        