##############################################################################
#
#   File:      dr_.py
#
#   Project:   DataRanking Project
#
#   Author(s): Romeu A. Pieritz [pieritz@esrf.fr]
#              Olof Svensson [svensson@esrf.fr]
#
#   Date:      2005/06/24
#
#   License:
#   --------------------------------------------------------------------------
#   Data Ranking Project Project
#   Copyright (c) 2005, Data Ranking Project developers (see above AUTHORS)
#   All rights reserved.
#
#   Redistribution and use in source and binary forms, with or without
#   modification, are permitted provided that the following conditions
#   are met:
#
#   Redistributions of source code must retain the above copyright notice,
#   this list of conditions and the following disclaimer.
#
#   Redistributions in binary form must reproduce the above copyright notice,
#   this list of conditions and the following disclaimer in the documentation
#   and/or other materials provided with the distribution.
#
#   Neither the names of DataRanking's copyright owner nor the names of its
#   contributors may be used to endorse or promote products derived from
#   this software without specific prior written permission.
#
#   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
#   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
#   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
#   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
#   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
#   TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
#   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
#   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
#   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
#   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
##############################################################################


from dr_definition                      import *
from dr_kernel                          import DRVerbose
from dr_system                          import DRToken
from dr_system                          import DRString
from dr_system                          import DRList
from dr_system                          import DRXml
from dr_dna                             import DRDna
from dr_dna_file_info                   import DRDnaFileInfo
from dr_dna_proposal                    import DRDnaProposal
from dr_dna_screening_output            import DRDnaScreeningOutput
from dr_dna_screening_output_lattice    import DRDnaScreeningOutputLattice
from dr_dna_screening_strategy          import DRDnaScreeningStrategy
from dr_dna_data_ranking                import DRDnaDataRanking
from dr_dna_sample_reference            import DRDnaSampleReference


# Warning!!
# Compatibility stuff here will be change when we starting to
# develop XSD engine= AALIB version to prevent the mistakes of the python version
# Not avaiable now


class DRDnaDataCrystal( DRDna ):
    
    def __init__( self ):
        DRDna.__init__( self )
        self.m_ScreeningOutput        = DRDnaScreeningOutput()
        self.m_ScreeningOutputLattice = DRDnaScreeningOutputLattice()
        self.m_ScreeningStrategy      = DRDnaScreeningStrategy()
        self.m_dataRank               = DRDnaDataRanking()
        self.m_dataExtendedXML        = None  # <xsd:string>
        #TO be erased in the future
        self.m_fileinfo               = DRDnaFileInfo()
        self.m_proposal               = DRDnaProposal()
        self.m_sample_reference       = DRDnaSampleReference()

        

            
    
    def inputXmlDna( self, _odrXml ):
        for ikey in self.__dict__:
             if ( ikey!=DRToken( "m_objectName" ) and ikey!=DRToken( "m_objectVersion" ) ):
                    if ( ikey!=DRToken( "m_objectID" ) and ikey!=DRToken( "m_objectMagicNumber" ) and ikey!=DRToken( "m_dataExtendedXML"  ) ):
                        if ( self.__dict__[ ikey ]!= None ):           
                            odrXmlElement = DRXml.getElementObject( _odrXml, DRXml.getAtributeToken( ikey ) )
                            if ( odrXmlElement!=None ):
                                 self.__dict__[ ikey ].inputXmlDna( odrXmlElement )
   
        #Fix to find the extensions in XML             
        odrXmlElement = DRXml.getElementObject( _odrXml, DRXml.getAtributeToken( "dataCrystal" ) )
        if ( odrXmlElement!=None ):
            odrValue = DRXml.getElementTokenValue( odrXmlElement, DRXml.getAtributeToken( DRToken( "m_dataExtendedXML" ) ) )
            if (odrValue!=None):
                 self.m_dataExtendedXML = odrValue
        else:
            odrValue = DRXml.getElementTokenValue( _odrXml, DRXml.getAtributeToken( DRToken( "m_dataExtendedXML" ) ) )
            if (odrValue!=None):
                 self.m_dataExtendedXML = odrValue
                 
       
 
    def outputXmlDna( self, _odrXml, _odrXmlElement ):
        for ikey in self.__dict__:
            if ( ikey == DRToken( "m_dataExtendedXML" ) and self.__dict__[ ikey ]!= None ):         
                odrXmlElement = _odrXml.createElement( DRXml.getAtributeToken( ikey ) )
                odrXmlElement.appendChild( _odrXml.createTextNode( DRString( self.__dict__[ ikey ] ) ) )      
                _odrXmlElement.appendChild( odrXmlElement )
            else:            
                if ( ikey!=DRToken( "m_objectName" ) and ikey!=DRToken( "m_objectVersion" ) ):
                    if ( ikey!=DRToken( "m_objectID" ) and ikey!=DRToken( "m_objectMagicNumber" ) and ikey!=DRToken( "m_dataExtendedXML"  )):
                        if ( self.__dict__[ ikey ]!= None ):         
                            self.__dict__[ ikey ].outputXmlDna( _odrXml, _odrXmlElement )
        
     
     
    # Interface to setup values
    def setResolutionObtained( self, _fResolution ):
        self.m_ScreeningOutput.setResolutionObtained( _fResolution )
    def getResolutionObtained( self ):
        return self.m_ScreeningOutput.getResolutionObtained( )
 


    # To be imported with the XSD code generation interface
    def setMosaicity( self, _fMosaicity ):
        self.m_ScreeningOutput.m_mosaicity =  _fMosaicity
    def getMosaicity( self ):
        return self.m_ScreeningOutput.m_mosaicity


    def setSpotsUsed( self, _iSpotsUsed ):
        self.m_ScreeningOutput.m_numSpotsUsed =  (int)( _iSpotsUsed )
    def getSpotsUsed( self ):
        return self.m_ScreeningOutput.m_numSpotsUsed


    def setSpotsFound( self, _iSpotsFound ):
        self.m_ScreeningOutput.m_numSpotsFound =  (int)( _iSpotsFound )
    def getSpotsFound( self ):
        return self.m_ScreeningOutput.m_numSpotsFound


    def setRotation( self, _fRotation ):
        self.m_ScreeningStrategy.setRotation( _fRotation )
    def getRotation( self ):
        return self.m_ScreeningStrategy.getRotation()



    def setPhiInit( self, _fPhiInit ):
        self.m_ScreeningStrategy.setPhiInit( _fPhiInit )
    def getPhiInit( self ):
        return self.m_ScreeningStrategy.getPhiInit()
    
    
    def setPhiEnd( self, _fPhiEnd ):
        self.m_ScreeningStrategy.setPhiEnd( _fPhiEnd )
    def getPhiEnd( self ):
        return self.m_ScreeningStrategy.getPhiEnd()
    

    def setExposureTime( self, _fExposureTime ):
        self.m_ScreeningStrategy.setExposureTime( _fExposureTime )
    def getExposureTime( self ):
        return self.m_ScreeningStrategy.getExposureTime()



    def setSpotsRejected( self, _iSpotsRejected ):
        self.m_ScreeningOutput.m_numSpotsRejected =  (int)( _iSpotsRejected )
    def getSpotsRejected( self ):
        return self.m_ScreeningOutput.m_numSpotsRejected



    def setSpotDeviationR( self, _fSpotDeviationR ):
        self.m_ScreeningOutput.m_spotDeviationR =  (float)(_fSpotDeviationR )
    def getSpotDeviationR( self ):
        return self.m_ScreeningOutput.m_spotDeviationR
    
    

    def setRank( self, fRank ):
        self.m_dataRank.m_rankValue        = fRank
    def getRank( self ):
        return self.m_dataRank.m_rankValue


    def setRankInformation( self, _odrString ):
        self.m_dataRank.m_rankInformation  = _odrString
    def getRankInformation( self ):
        return self.m_dataRank.m_rankInformation


    def setRankEngine( self, _odrString ):
        self.m_dataRank.m_rankEngine  = _odrString
    def getRankEngine( self ):
        return self.m_dataRank.m_rankEngine

 

##############################################################################
