##############################################################################
#
#   File:      dr_.py
#
#   Project:   DataRanking Project
#
#   Author(s): Romeu A. Pieritz [pieritz@esrf.fr]
#              Olof Svensson [svensson@esrf.fr]
#
#   Date:      2005/06/24
#
#   License:
#   --------------------------------------------------------------------------
#   Data Ranking Project Project
#   Copyright (c) 2005, Data Ranking Project developers (see above AUTHORS)
#   All rights reserved.
#
#   Redistribution and use in source and binary forms, with or without
#   modification, are permitted provided that the following conditions
#   are met:
#
#   Redistributions of source code must retain the above copyright notice,
#   this list of conditions and the following disclaimer.
#
#   Redistributions in binary form must reproduce the above copyright notice,
#   this list of conditions and the following disclaimer in the documentation
#   and/or other materials provided with the distribution.
#
#   Neither the names of DataRanking's copyright owner nor the names of its
#   contributors may be used to endorse or promote products derived from
#   this software without specific prior written permission.
#
#   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
#   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
#   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
#   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
#   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
#   TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
#   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
#   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
#   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
#   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
##############################################################################


from dr_definition                  import *
from dr_kernel                      import DRObject
from dr_kernel                      import DRVerbose
from dr_system                      import DRToken
from dr_system                      import DRString
from dr_system                      import DRList
from dr_system                      import DRXml
from dr_system                      import DRTime
from dr_factor_resolution           import DRFactorResolution
from dr_dna_data_crystal            import DRDnaDataCrystal


class DRCrystal( DRObject ):
    
    def __init__( self, _odrCrystalName = DRString( "DRCrystal" ) ):
        DRObject.__init__( self )
        self.setName( DRString( _odrCrystalName ) )
        self.m_fRank             = DR_RANK_REFERENCE_VALUE
        self.m_odrEngineType     = DRToken( "DREngine" )
        self.m_odrListFactor     = DRList()   
        self.m_odrDnaDataCrystal = DRDnaDataCrystal()
        self.m_bisValidProject   = True
        self.m_ofTotalTime       = 0
        self.m_ofTotalImages     = 0
    
    def setTotalTime( self, _fTime ):
        self.m_ofTotalTime = _fTime
    def getTotalTime( self ):
        return self.m_ofTotalTime
        
     
    def setTotalImages( self, _fImages ):
        self.m_ofTotalImages = _fImages
    def getTotalImages( self ):
        return self.m_ofTotalImages
        
        
        
    def setEngineType( self, _odrEngineType ):
        self.m_odrEngineType = DRToken( _odrEngineType )
    def getEngineType( self ):
        return DRToken(  self.m_odrEngineType )
        
    
    
    def getFactor( self, _odrToken ):
        for i in self.m_odrListFactor:
            if i.getName().equals( DRToken( _odrToken ) ):
                return i.duplicate()
            
            
    def setFactor( self, _odrFactor ):
        for i in self.m_odrListFactor:
            if i.getMagicNumber() == _odrFactor.getMagicNumber():
                i = _odrFactor.duplicate()               
                return
        self.m_odrListFactor.add( _odrFactor.duplicate() )
    
    
    def addFactor( self, _odrFactor ):
        self.setFactor( _odrFactor )
        
        
    def outputScreen( self, _ielem = 0 ):
        for i in self.m_odrListFactor:
            odrString = "ProjectData:: " + DRString( _ielem ) + " > " + self.getName()+ " > " + DRString( self.getRank() ) + " > " + i.getName() + " > " + DRString( i.getRank() )
            DRVerbose.screen( odrString )
            


   
    # Interface to setup values
    def setResolutionObtained( self, _fResolution ):
        self.m_odrDnaDataCrystal.setResolutionObtained( _fResolution )
    def getResolutionObtained( self ):
        return self.m_odrDnaDataCrystal.getResolutionObtained()
    
    
    def setRank( self, fRank ):
        self.m_odrDnaDataCrystal.setRank( fRank )
        self.m_fRank = self.m_odrDnaDataCrystal.getRank()
    def getRank( self ):
        self.m_fRank = self.m_odrDnaDataCrystal.getRank()
        return self.m_fRank


    def setRankEngine( self, _odrString ):
        self.m_odrDnaDataCrystal.setRankEngine( _odrString )
        self.m_odrEngineType = _odrString
    def getRankEngine( self ):
        self.m_odrEngineType = self.m_odrDnaDataCrystal.getRankEngine()
        return self.m_odrEngineType


    def setRankInformation( self, _odrString ):
        self.m_odrDnaDataCrystal.setRankInformation( _odrString )
    def getRankInformation( self ):
        return self.m_odrDnaDataCrystal.getRankInformation()


    def setMosaicity( self, _fMosaicity ):
        self.m_odrDnaDataCrystal.setMosaicity( _fMosaicity )
    def getMosaicity( self ):
        return self.m_odrDnaDataCrystal.getMosaicity()


    def setSpotsUsed( self, _iSpotsUsed ):
        self.m_odrDnaDataCrystal.setSpotsUsed( _iSpotsUsed )
    def getSpotsUsed( self ):
        return self.m_odrDnaDataCrystal.getSpotsUsed()


    def setSpotsFound( self, _iSpotsFound ):
        self.m_odrDnaDataCrystal.setSpotsFound( _iSpotsFound )
    def getSpotsFound( self ):
        return self.m_odrDnaDataCrystal.getSpotsFound()

    def setSpotsRejected( self, _iSpotsRejected ):
        self.m_odrDnaDataCrystal.setSpotsRejected( _iSpotsRejected )
    def getSpotsRejected( self ):
        return self.m_odrDnaDataCrystal.getSpotsRejected()

    def setSpotDeviationR( self, _fSpotDeviationR ):
        self.m_odrDnaDataCrystal.setSpotDeviationR( _fSpotDeviationR )
    def getSpotDeviationR( self ):
        return self.m_odrDnaDataCrystal.getSpotDeviationR()




    def setRotation( self, _fRotation ):
        self.m_odrDnaDataCrystal.setRotation( _fRotation )
    def getRotation( self ):
        return self.m_odrDnaDataCrystal.getRotation()


    def setPhiInit( self, _fPhiInit ):
        self.m_odrDnaDataCrystal.setPhiInit( _fPhiInit )
    def getPhiInit( self ):
        return self.m_odrDnaDataCrystal.getPhiInit()
    
    
    def setPhiEnd( self, _fPhiEnd ):
        self.m_odrDnaDataCrystal.setPhiEnd( _fPhiEnd )
    def getPhiEnd( self ):
        return self.m_odrDnaDataCrystal.getPhiEnd()
    
    

    def setExposureTime( self, _fExposureTime ):
        self.m_odrDnaDataCrystal.setExposureTime( _fExposureTime )
    def getExposureTime( self ):
        return self.m_odrDnaDataCrystal.getExposureTime()



    def testIntegrity( self ):
        return self.m_bisValidProject


    # DNA BioXHIT Compatibility Layer ########################################
    def importXmlDna( self, _odrString ):
        odrXml = DRXml( "crystalObject" )
        odrXml.input( DRString( _odrString ) )
        self.inputXmlDna( odrXml )
        odrXmlElement = odrXml.getElement( "dataCrystal" )
        if (odrXmlElement!=None):
            self.m_bisValidProject = True
        else:
            self.m_bisValidProject = False
        odrXml.destroy()
    
            
 
    def exportXmlDna( self, _odrString ):
        odrXml = DRXml( "dataCrystal" )
        odrXml.addComment( "# Asynchronous Action Library Project" )
        odrXml.addComment( "# Version   :: " + DRString( "0.9" ))
        odrXml.addComment( "# Date      :: " + DRTime.timeString())          
        odrXml.addComment( "# DNA BioXHIT Compatible XML file" )
        self.outputXmlDna( odrXml, odrXml.rootNode() )
        odrXml.output( DRString( _odrString ) )
        odrXml.destroy()
        
        

    def inputXmlDna( self, _odrXml ):
        self.m_odrDnaDataCrystal.inputXmlDna( _odrXml )
    
 
    def outputXmlDna( self, _odrXml, _odrXmlElement, _bCreateElement = False ):  
        odrXmlElement = _odrXmlElement
        if ( _bCreateElement == True ):
            odrXmlElement = _odrXml.createElement( "dataCrystal" )
            _odrXmlElement.appendChild( odrXmlElement )
        
        self.m_odrDnaDataCrystal.outputXmlDna( _odrXml, odrXmlElement )
 
    
        
##############################################################################
