##############################################################################
#
#   File:      dr_.py
#
#   Project:   DataRanking Project
#
#   Author(s): Romeu A. Pieritz [pieritz@esrf.fr]
#              Olof Svensson [svensson@esrf.fr]
#
#   Date:      2005/06/24
#
#   License:
#   --------------------------------------------------------------------------
#   Data Ranking Project Project
#   Copyright (c) 2005, Data Ranking Project developers (see above AUTHORS)
#   All rights reserved.
#
#   Redistribution and use in source and binary forms, with or without
#   modification, are permitted provided that the following conditions
#   are met:
#
#   Redistributions of source code must retain the above copyright notice,
#   this list of conditions and the following disclaimer.
#
#   Redistributions in binary form must reproduce the above copyright notice,
#   this list of conditions and the following disclaimer in the documentation
#   and/or other materials provided with the distribution.
#
#   Neither the names of DataRanking's copyright owner nor the names of its
#   contributors may be used to endorse or promote products derived from
#   this software without specific prior written permission.
#
#   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
#   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
#   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
#   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
#   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
#   TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
#   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
#   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
#   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
#   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
##############################################################################


from    dr_system           import  *
from    dr_kernel           import  *
from    dr_engine           import  *
from    dr_engine_plugin    import  *


if __name__ == '__main__':
     
     
    # Application Framework Definition
    odrApplication = DRApplication( "DataRanking", "0.9.2" )
      
      
    # DataRanking Kernel
    odrDataRanking = DRDataRanking()
    

    # Adding PLUGINS: ie. PERSONAL Ranking Engines  #####################
    odrDataRanking.addEngine( DRPluginEnginePerso01( "EnginePerso01" ) )
    odrDataRanking.addEngine( DRPluginEnginePerso02( "EnginePerso02" ) )
    # ###################################################################
      
  
    # Adding Standart Ranking Engines
    odrDataRanking.addEngine( DREngineMosaicity( "DREngineMosaicity" ) )
    odrDataRanking.addEngine( DREngineResolutionObtained( "DREngineResolutionObtained" ) )
    odrDataRanking.addEngine( DREngineResolutionMosaicity( "DREngineResolutionMosaicity" ) )
    odrDataRanking.addEngine( DREngineSpotsUsed( "DREngineSpotsUsed" ) )
    odrDataRanking.addEngine( DREngineSpotsFound( "DREngineSpotsFound" ) )
    odrDataRanking.addEngine( DREngineSpotsRejected( "DREngineSpotsRejected" ) )
    odrDataRanking.addEngine( DREngineSpotDeviationR( "DREngineSpotDeviationR" ) )
    odrDataRanking.addEngine( DREngineDataCollectionTime( "DREngineDataCollectionTime" ) )
    odrDataRanking.addEngine( DREngineDataCollectionNumberImage( "DREngineDataCollectionNumberImage" ) )
    #.......
    #.......
   
    
    # Manager
    odrManagerDataRanking = DRManagerDataRanking( odrDataRanking )
    
    
    # Command Definitions
    odrApplication.addCommand( "--ip", odrManagerDataRanking.inputProject )
    odrApplication.addCommand( "--op", odrManagerDataRanking.outputProject )
    odrApplication.addCommand( "--rcrystal", odrManagerDataRanking.inputCrystalToRank )
    odrApplication.addCommand( "--rproject", odrManagerDataRanking.inputProjectToRank )
    odrApplication.addCommand( "--rengine",  odrManagerDataRanking.setRankEngine )
    
    
    # Command Definitions Compatibility with DNA BioXHIT Project
    odrApplication.addCommand( "--ipDNA", odrManagerDataRanking.inputProject )
    odrApplication.addCommand( "--opDNA", odrManagerDataRanking.outputProject )
    odrApplication.addCommand( "--rcrystalDNA", odrManagerDataRanking.inputCrystalToRank )
    odrApplication.addCommand( "--rprojectDNA", odrManagerDataRanking.inputProjectToRank )

    
    # Execution
    odrApplication.executeConnect( odrManagerDataRanking.execute )
    odrApplication.execute()


##############################################################################


















