##############################################################################
#
#   File:      unittest_al_classes_system.py
#
#   Project:   Asynchronous Action Library Project
#              http://aalib.sourceforge.net/
#
#   Author(s): Romeu A. Pieritz & Olof Svensson
#   Contact  : aalib_info@yahoo.com
#
#   Date:      2005/06/24
#
#   License:
#   --------------------------------------------------------------------------
#   Asynchronous Action Library Project
#   Copyright (c) 2005, AALib developers (see above AUTHORS)
#   All rights reserved.
#
#   Redistribution and use in source and binary forms, with or without
#   modification, are permitted provided that the following conditions
#   are met:
#
#   Redistributions of source code must retain the above copyright notice,
#   this list of conditions and the following disclaimer.
#
#   Redistributions in binary form must reproduce the above copyright notice,
#   this list of conditions and the following disclaimer in the documentation
#   and/or other materials provided with the distribution.
#
#   Neither the names of AALib's copyright owner nor the names of its
#   contributors may be used to endorse or promote products derived from
#   this software without specific prior written permission.
#
#   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
#   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
#   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
#   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
#   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
#   TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
#   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
#   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
#   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
#   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
##############################################################################


from al_python  import *
from al_system  import *
from al_kernel  import *


 
##############################################################################
# ALString

class UnitTestALString( ALTestCase ): 
    
    def testALString( self ):
        print "\nUnitTest ALString:\n"

        oalString0 = ALString( "Test ALString" )
        print "Getting String: " + oalString0
        #print "Equal banane String: " + oalString0.equals( "banane" )
        
        oalString1  = oalString0.duplicate()
        oalString1a = oalString0 
        
        print "Test duplicate: " + oalString1
        print "Test egal: " + str( oalString0.equals( oalString1 ) )
        print "Test if same instance 1: " + str( oalString0 is oalString1 )
        print "Test if same instance 2: " + str( oalString0 is oalString1a )
        
        oalString2 = ALString( "oooOOOooo" )        
        print "Test upperCase: " + oalString2 + " after capitalize: " + oalString2.capitalize()
        
        print "\nEnd UnitTest ALString \n\n"
             
 
 
##############################################################################
# ALTime

class UnitTestALTime( ALTestCase ): 
    def testALTime( self ):
        ALVerbose.unitTest( "Test ALTime" )
        oalTime = ALTime()
        ALVerbose.unitTest()
        
        
        

##############################################################################
# ALSystem

class UnitTestModuleSystem( ALTestCase ): 
    def testModuleSystem( self ):
        ALVerbose.unitTest( "Test Module System" )
    
        ALVerbose.unitTest( "OS        :" + ALSystem.getOSName() )
        ALVerbose.unitTest( "OSType    :" + ALSystem.getOSType() )
        ALVerbose.unitTest( "OSVersion :" + ALSystem.getOSVersion() )
        ALVerbose.unitTest( "Machine   :" + ALSystem.getMachineVersion() )
        ALVerbose.unitTest( "HostName  :" + ALSystem.getHostName() )
        ALVerbose.unitTest( "Host      :" + ALSystem.getHost() )
        ALVerbose.unitTest( "HostIP    :" + ALSystem.getHostIP() )
        ALVerbose.unitTest( "UserName  :" + ALSystem.getUserName() )
        ALVerbose.unitTest( "Compiler  :" + ALSystem.getCompilerName() )
        ALVerbose.unitTest( "Program   :" + ALSystem.getProgramName() )
        ALVerbose.unitTest( "UName     :" + ALString( ALSystem.getUName() ) )
       
       
        ALVerbose.unitTest( "Path      :" + ALDiskExplorer.getCwd() )
        ALVerbose.unitTest( "USER Path :" + ALSystem.getUserPath() )
    
    
    
        #oalbuu = ALString( "coucou" )
        #oaltoto = ALString( oalbuu )
        ##print oalbuu, type(oalbuu), type(oaltoto)
        #
        #ALVerbose.unitTest( oalbuu )
        #ALVerbose.unitTest( type( oalbuu ) )
        #ALVerbose.unitTest( type( oaltoto ) )
        ##self.failIf( not oaltoto.equals( "coucou" ) )
        #ALVerbose.unitTest( "%s equals %s: %s" % ( oaltoto, "coucou", oaltoto.equals( "coucou" ) ) )
        #
        #oalList = ALList()
        #oalList.append(1)
        ##print oalList, type( oalList )
        #ALVerbose.unitTest( oalList )
        #ALVerbose.unitTest( type( oalList ) )
        #
        #
        #oalDict = ALDict()
        #oalDict["a"] = "b"
        #ALVerbose.unitTest( oalDict )
        #ALVerbose.unitTest( type( oalDict ) )
        #
        #
        #oalThread = ALThread() 
        #ALVerbose.unitTest( oalThread.getID() )
        #ALVerbose.unitTest( oalThread.getMagicNumber() )
        #ALVerbose.unitTest( type( oalThread ) )
        #
        #
        #oalThreadingCondition = ALThreadingCondition() 
        #ALVerbose.unitTest( oalThread.getID() )
        #ALVerbose.unitTest( oalThread.getMagicNumber() )
        #ALVerbose.unitTest( type( oalThreadingCondition ) )
        #

        ALVerbose.unitTest()



        
##############################################################################
# ALMultiMethod

class foo:
    def __init__( self ):
        pass   
    @multimethod( int )
    def bar( a ):
        print "[PARENT] Integer a: %d" % a
    @multimethod( float )    
    def bar( a ):
        print "[PARENT] Float a: %f" % a 
    @multimethod( str, int )
    def bar( a, b ):
        print "[PARENT] String a and integer b: %s and %d" % ( a, b )
    bar = staticmethod( bar )


class child( foo ):
    def __init__( self ):
        foo.__init__( self )
    def barbar( self, a, b ):
         print "[CHILD] String a and integer b: %s and %d" % ( a, b )

    #def bar( self, a, b ):
    #    print "CHILD: String a and integer b: %s and %d" % ( a, b )
    #@multimethod( int )
    #def bar( a ):
    #    print "[CHILD] Integer a: %d" % a
    #@multimethod( float )    
    #def bar( a ):
    #    print "[CHILD]  Float a: %f" % a
    #@multimethod( str, int )
    #def bar( a, b ):
    #    print "[CHILD] String a and integer b: %s and %d" % ( a, b )
    #bar = staticmethod( bar )
    
class UnitTestMultiMethod( ALTestCase ): 
    def testMultiMethod( self ):
        ALVerbose.unitTest( "Test MultiMethod" )
        e = foo()
        e.bar(1)
        e.bar(1.0)
        e.bar( "coco", 5 )
        b = child()
        b.bar(2)
        b.bar(3.0)
        b.barbar( "bobo", 1 )
        ALVerbose.unitTest()
        
        
       
##############################################################################
# ALThread
     
class TestALThreadScreen( ALThread ):
    
    def __init__( self, _iThreadNo, _fSleepTime ):
        ALThread.__init__( self )
        self.m_iThreadNo  = _iThreadNo
        self.m_fSleepTime = _fSleepTime
        
    def run( self ):
        for i in range( 1, 5 ):
            #while True:
                ALVerbose.screen( "Output from thread %d" % self.m_iThreadNo )
                ALTime.sleep( self.m_fSleepTime )

class UnitTestALThread( ALTestCase ): 
    def testALThread( self ):
        ALVerbose.unitTest( "Test ALThread" )
        thread1 = TestALThreadScreen( 1, 0.1 )
        thread2 = TestALThreadScreen( 2, 0.3 )
        thread3 = TestALThreadScreen( 3, 0.01 )
        thread4 = TestALThreadScreen( 4, 0.2 )
        thread5 = TestALThreadScreen( 5, 0.05 )
        thread1.execute()
        thread2.execute()
        thread3.execute()
        thread4.execute()
        thread5.execute()
        ALVerbose.unitTest( )




##############################################################################
# ALListArgument

class UnitTestALListArgument( ALTestCase ): 
    
    def testALListArgument( self ):
        ALVerbose.unitTest( "UnitTest ALListArgument:" )
        
        
        oalList1 = ALList()
        oalList1.append( "--coucou1" )
        oalList1.append( "valeu_coucou1" )
        oalList1.append( "-h1" )
        oalList1.append( "--man1" )
        ALVerbose.unitTest( oalList1 )

        oalList2 = ["--coucou2", "valeu_coucou2", "-h2", "--man2"]
        ALVerbose.unitTest( oalList2 )
        
        oalList3 = ALList( ["--coucou3", "valeu_coucou3", "-h3", "--man3"] )
        ALVerbose.unitTest( oalList3 )
  
        oalList4 = ALList( oalList2 )
        ALVerbose.unitTest( oalList4 )
        
        
        #oalListArgument = ALListArgument( oalList3 )
        oalListArgument = ALCommandLineArgument()
        ALVerbose.unitTest( oalListArgument )
        
        ALVerbose.unitTest() 
             
 
 
##############################################################################
# ALTrace

class UnitTestALTrace( ALTestCase ): 
    def testALTrace( self ):
        ALVerbose.unitTest( "Test ALTrace" )
        try:
            oh_there_is_a_banana_in_the_program
        except:
            ALTrace.trace()
            ALVerbose.unitTest()
        
                      
                
##############################################################################
# ALDiskExplorer

class UnitTestIteract:
    def printIteract( self, _pyArg, _pyFolder, _pyFiles ):
        oalStrFolder = ALDiskExplorer.normPath( _pyFolder )
        oalStrArg    = ALString( _pyArg )
        oalListFile  = ALList( _pyFiles )
        oalStrCurFolder = ALDiskExplorer.mergePath( ALDiskExplorer.getCurrentFolder(), oalStrFolder ) 
        print oalStrArg + " > " + oalStrCurFolder   
        # Print Folders
        for ifile in oalListFile:
            if ALDiskExplorer.isFolder( ALDiskExplorer.mergePath( oalStrCurFolder, ifile ) ):
                print "              |-->FOLDER::" + ALString( ifile )          
       # Print Links
        for ifile in oalListFile:
            if ALDiskExplorer.isLink( ALDiskExplorer.mergePath( oalStrCurFolder, ifile ) ):
                print "              |-->LINK  ::" + ALString( ifile )         
        # Print files
        for ifile in oalListFile:
            if ALDiskExplorer.isFile( ALDiskExplorer.mergePath( oalStrCurFolder, ifile ) ):
                print "              |-->FILE  ::" + ALString( ifile )
         
            
    def printTree( self, _pyArg, _pyFolder, _pyFiles ):
        oalStrFolder = ALDiskExplorer.normPath( _pyFolder )
        oalStrArg    = ALString( _pyArg )
        oalListFile  = ALList( _pyFiles )
        oalStrCurFolder =  oalStrFolder
        ilenght = len( oalStrCurFolder )
        print "> ./" + oalStrCurFolder
        # Print files
        for ifile in oalListFile:
            if ALDiskExplorer.isFile( ALDiskExplorer.mergePath( oalStrCurFolder, ifile ) ):
                oalString = ALString( " " )
                for i in range( 0, ilenght+2):
                    oalString += ALString( " " )
                print oalString + "|-->" + ALString( ifile )
            
            
        
class UnitTestALDiskExplorer( ALTestCase ):
   
    def testALDiskExplorer( self ):
        ALVerbose.unitTest( "Test ALDiskExplorer" )
        
     
        oalDiskExplorer = ALDiskExplorer()
             
        ALVerbose.unitTest( "Creating Folder :" + "./folderCreatedToBeDeleted" )
        oalDiskExplorer.createFolder( "./folderCreatedToBeDeleted" )
        ALVerbose.unitTest( "DELETING Folder :" + "./folderCreatedToBeDeleted" )
        oalDiskExplorer.deleteFolder( "./folderCreatedToBeDeleted" )
           
        ALVerbose.unitTest( ALDiskExplorer.normDrive( PyOS.getcwd() ) )
        ALVerbose.unitTest( ALDiskExplorer.getCwd() )
        ALVerbose.unitTest( ALDiskExplorer.getCurrentFolder() )
        ALVerbose.unitTest( ALDiskExplorer.absPath( PyOS.getcwd()  )  )
        ALVerbose.unitTest( ALDiskExplorer.absPath( ALDiskExplorer.getCurrentFolder() )  )
 
        ALVerbose.unitTest( ALDiskExplorer.getFileList( "../modules" ) )
        #ALVerbose.unitTest( ALDiskExplorer.getFileList( "./" ) )
        #
       ## oalListFile = ALDiskExplorer.getFileList( "./" )
       # oalListFile = ALDiskExplorer.getFolderList( "../modules" )
       # for ifile in oalListFile:
       #     if ALDiskExplorer.isFile( ifile ):
       #         ALVerbose.unitTest( ALString( ifile ) + "->isFile" )
       #     elif ALDiskExplorer.isDirectory( ifile ):
       #         ALVerbose.unitTest( ALString( ifile ) + "->isDirectory" )
       #     elif ALDiskExplorer.isLink( ifile ):
       #         ALVerbose.unitTest( ALString( ifile ) + "->isLink" )
       #         
           
    
     #   ALDiskExplorer.iteractPath( "../modules", UnitTestIteract().printIteract, "Executing::" )
  #     ALDiskExplorer.iteractPath( "./", UnitTestIteract().printIteract, "TreeView::" )
        ALDiskExplorer.iteractPath( "./", UnitTestIteract().printTree, "TreeView::" )
        
        oalStrCurrentFolder = ALDiskExplorer.getCurrentFolder()
        ALVerbose.unitTest( "Current Folder " + oalStrCurrentFolder )
        ALDiskExplorer.setCurrentFolder( "../modules" )
        ALVerbose.unitTest( "New Current Folder " + ALDiskExplorer.getCurrentFolder() )
        ALDiskExplorer.setCurrentFolder( oalStrCurrentFolder )
        ALVerbose.unitTest( "New Current Folder " + ALDiskExplorer.getCurrentFolder() )
    
        
        ALVerbose.unitTest()
        
        
        
        
        
##############################################################################
# ALXml

class UnitTestALXml( ALTestCase ): 
    def testALXml( self ):
        ALVerbose.unitTest( "Test ALXml" )
        
       # oalXml = ALXml()
       # must to try to clone the stupid document to do a copy to our ALXml object type
        oalXml = ALXml.createXml( "input-test.xml" )        
   
        oalStreamXml = ALStreamXml( "./output-test.xml" )
        oalStreamXml.write( oalXml )
        oalStreamXml.close()
        
        oalStreamXml2 = ALStreamXml( "./output-test.xml", "r" )
        oalXml2 = oalStreamXml2.read()
        oalStreamXml2.close()
        
        for inode in  oalXml2.getElementsByTagName( "file" ):
            oalXmlNode = inode  # impossible to copy the stupid node objects
            oUrlOrig = oalXmlNode.getAttribute( "url" )          
            ALVerbose.screen( ALString( oUrlOrig ) )
        
        ALVerbose.unitTest()
        
        
        
##############################################################################


class ALUnitTestSystem( ALUnitTest ):
    def preProcessor( self ):   
        self.addTestMethod( UnitTestALString().testALString )
        self.addTestMethod( UnitTestALTrace().testALTrace )
        self.addTestMethod( UnitTestALTime().testALTime )
        self.addTestMethod( UnitTestModuleSystem().testModuleSystem)
        self.addTestMethod( UnitTestMultiMethod().testMultiMethod )
        self.addTestMethod( UnitTestALThread().testALThread )
        self.addTestMethod( UnitTestALListArgument().testALListArgument )
        self.addTestMethod( UnitTestALDiskExplorer().testALDiskExplorer )
        self.addTestMethod( UnitTestALXml().testALXml )

    

##############################################################################
  
if __name__ == '__main__':

    oalUnitTestSystem = ALUnitTestSystem( "Test System" )
    oalUnitTestSystem.execute()


