##############################################################################
#
#   File:      unittest_al_classes_script.py
#
#   Project:   Asynchronous Action Library Project
#              http://aalib.sourceforge.net/
#
#   Author(s): Romeu A. Pieritz & Olof Svensson
#   Contact  : aalib_info@yahoo.com
#
#   Date:      2005/06/24
#
#   License:
#   --------------------------------------------------------------------------
#   Asynchronous Action Library Project
#   Copyright (c) 2005, AALib developers (see above AUTHORS)
#   All rights reserved.
#
#   Redistribution and use in source and binary forms, with or without
#   modification, are permitted provided that the following conditions
#   are met:
#
#   Redistributions of source code must retain the above copyright notice,
#   this list of conditions and the following disclaimer.
#
#   Redistributions in binary form must reproduce the above copyright notice,
#   this list of conditions and the following disclaimer in the documentation
#   and/or other materials provided with the distribution.
#
#   Neither the names of AALib's copyright owner nor the names of its
#   contributors may be used to endorse or promote products derived from
#   this software without specific prior written permission.
#
#   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
#   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
#   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
#   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
#   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
#   TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
#   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
#   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
#   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
#   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
##############################################################################


from al_python  import *
from al_system  import *
from al_kernel  import *
from al_script  import *


##############################################################################
# Module ALScript

class UnitTestALScript( ALTestCase ): 
    def testALScript( self ):
        ALVerbose.unitTest( "Test ALScript" )
        oalScript = ALScript()
        oalScript.execute()
        ALVerbose.unitTest()
        
  
##############################################################################
# Module ALScriptEpyDoc

class UnitTestALScriptEpyDoc( ALTestCase ): 
    def testALScriptEpyDoc( self ):
        ALVerbose.unitTest( "Test ALScriptEpyDoc" )
        oalScript = ALScriptEpyDoc( "ScriptEpyDoc" )
        oalScript.execute()
        ALVerbose.unitTest()
        
        
##############################################################################
# Module ALScriptKomodo

class UnitTestALScriptKomodo( ALTestCase ): 
    def testALScriptKomodo( self ):
        ALVerbose.unitTest( "Test ALScriptKomodo" )
        oalScript = ALScriptKomodo( "ScriptKomodo" )
        oalScript.execute()
        ALVerbose.unitTest()
        
        
##############################################################################
# Module ALScriptCompile

class UnitTestALScriptCompile( ALTestCase ): 
    def testALScriptCompile( self ):
        ALVerbose.unitTest( "Test ALScriptCompile" )
        oalScript = ALScriptCompile( "ScriptCompile" )
        oalScript.execute()
        ALVerbose.unitTest()
               
               
##############################################################################
# Module ALScriptMD5Sum

class UnitTestALScriptMD5Sum( ALTestCase ): 
    def testALScriptMD5Sum( self ):
        ALVerbose.unitTest( "Test ALScriptMD5Sum" )
        oalScript = ALScriptMD5Sum( "md5sum" )
        oalScript.addCommand( "--reset", oalScript.reset )
        oalScript.execute()
        ALVerbose.unitTest()
        
               
##############################################################################
# Module ALScriptVersionControl

class UnitTestALScriptVersionControl( ALTestCase ): 
    def testALScriptVersionControl( self ):
        ALVerbose.unitTest( "Test ALScriptVersionControl" )
        oalScript = ALScriptVersionControl( "VersionControl" )
        oalScript.addCommand( "--reset", oalScript.reset )
        oalScript.execute()
        ALVerbose.unitTest()
        
        
##############################################################################


class ALUnitTestScript( ALUnitTest ):
    def preProcessor( self ):   
        self.addTestMethod( UnitTestALScript().testALScript )
        self.addTestMethod( UnitTestALScriptEpyDoc().testALScriptEpyDoc ) 
        self.addTestMethod( UnitTestALScriptCompile().testALScriptCompile )
        self.addTestMethod( UnitTestALScriptMD5Sum().testALScriptMD5Sum )
        self.addTestMethod( UnitTestALScriptVersionControl().testALScriptVersionControl )
        
        # Do not test it during komodo runtime
        #self.addTestMethod( UnitTestALScriptKomodo().testALScriptKomodo )
       

##############################################################################
  
if __name__ == '__main__':

    oalUnitTestScript = ALUnitTestScript( "Test Script" )
    oalUnitTestScript.execute()
     

     
