##############################################################################
#
#   File:      unittest_al_classes_kernel.py
#
#   Project:   Asynchronous Action Library Project
#              http://aalib.sourceforge.net/
#
#   Author(s): Romeu A. Pieritz & Olof Svensson
#   Contact  : aalib_info@yahoo.com
#
#   Date:      2005/06/24
#
#   License:
#   --------------------------------------------------------------------------
#   Asynchronous Action Library Project
#   Copyright (c) 2005, AALib developers (see above AUTHORS)
#   All rights reserved.
#
#   Redistribution and use in source and binary forms, with or without
#   modification, are permitted provided that the following conditions
#   are met:
#
#   Redistributions of source code must retain the above copyright notice,
#   this list of conditions and the following disclaimer.
#
#   Redistributions in binary form must reproduce the above copyright notice,
#   this list of conditions and the following disclaimer in the documentation
#   and/or other materials provided with the distribution.
#
#   Neither the names of AALib's copyright owner nor the names of its
#   contributors may be used to endorse or promote products derived from
#   this software without specific prior written permission.
#
#   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
#   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
#   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
#   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
#   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
#   TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
#   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
#   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
#   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
#   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
##############################################################################


from al_system  import *
from al_kernel  import *
from al_action  import *
from al_math    import *


##############################################################################
# ALObject

class UnitTestALObject( ALTestCase ): 
    
    def testALObject( self ):
        print "\nUnitTest ALObject:\n"
 
        oalObject0 = ALObject()
        print oalObject0.getMagicNumber()
        print oalObject0.getID()
        print oalObject0.getVersion()
        print oalObject0.getName()
        
        oalObject1 = oalObject0.duplicate()
        if oalObject1.getID()==oalObject0.getID():
            print "Two Objects have the same ID: " + oalObject1.getID()
            print "Copy object: " + oalObject1.getMagicNumber()
        else :
            print "error = Two Objects have different IDs "
            
        oalXmlObject = ALXml( "alobject-test-xml")
        oalXmlObject.addComment( "Test of ALObject Output in XML " )
        oalXmlObject.addObject( oalObject1 )
        oalXmlObject.output( "alobject-test.xml", True )
        oalXmlObject.destroy()
        

        oalXmlRead = ALXml()
        oalXmlRead.input( "alobject-test.xml" )
        oalXmlRead.output( "alobject-test-COPY.xml" )
        oalXmlRead.close()
        
        
        print "\nEnd UnitTest ALObject \n\n"
        


##############################################################################
# ALLogFile

class UnitTestALLogFile( ALTestCase ): 
    
    def testALLogFile( self ):
        ALVerbose.unitTest( "UnitTest ALLogFile:" )
        
        oalLogFile = ALLogFile()
        oalLogFile.log( "  Log Test in the Screen by the Parent Class \n" )
  
        ALVerbose.unitTest()
 
 
##############################################################################
# ALVerbose

class UnitTestALVerbose( ALTestCase ): 
    
    def outputLoop( self ):
        limit = 1000
        for i in range( 1, limit ):  
            ALVerbose.screen( i, limit )
        limit = 10000
        for i in range( 1, limit ):  
            ALVerbose.screen( i, limit )

    def testALVerbose( self ):
        ALVerbose.unitTest( "UnitTest ALVerbose:" )
           
        ALVerbose.screen( "Testing the verbose controls...." )
        ALVerbose.screen( "Log File output Option is ON" )
        ALVerbose.setLogFileOn( )
        ALVerbose.screen( "log is ON 1" )
        ALVerbose.setLogFileOff( )
        ALVerbose.screen( "log is OFF" )
        ALVerbose.setLogFileOn( )
        ALVerbose.screen( "log is ON 2" )   
        #self.outputLoop()
        
        ALVerbose.setVerboseOff()
        ALVerbose.screen( "log is FORCED off" )
        ALVerbose.DEBUG( "Test information DEBUG off" )
        ALVerbose.setVerboseDebugOn()
        ALVerbose.screen( "log is FORCED on" )
        ALVerbose.DEBUG( "Test information DEBUG on" )
        ALVerbose.setVerboseDebugOff()
        ALVerbose.DEBUG( "Test information DEBUG off" )
        ALVerbose.screen( "log is OFF FINAL" )
        
        ALVerbose.unitTest()
 
 

##############################################################################
# ALStream

class UnitTestALStream( ALTestCase ): 
    
    def testALStream( self ):
        ALVerbose.unitTest( "UnitTest ALStream:" )
           
        oalStream = ALStream()
        oalStream.write( "something" )
        oalStream.close()

        ALVerbose.unitTest()
        
         
##############################################################################
# ALStreamFile

class UnitTestALStreamFile( ALTestCase ): 
    
    def testALStreamFile( self ):
        ALVerbose.unitTest( "UnitTest ALStreamFile:" )
           
        oalStreamFile = ALStreamFile( "TestFileStreamAscii.txt" )
        oalStreamFile.write( "something in the file" )
        oalStreamFile.close()

        ALVerbose.unitTest()
        
        
##############################################################################
# ALStreamPipe

class UnitTestALStreamPipe( ALTestCase ): 
    
    def testALStreamPipe( self ):
        ALVerbose.unitTest( "UnitTest ALStreamPipe:" )
           
        oalStreamPipe = ALStreamPipe()
        oalStreamPipe.write( "something in the pipe" )
        oalStreamPipe.close()

        ALVerbose.unitTest()

  

##############################################################################
# ALRessource

class UnitTestALResource( ALTestCase ): 
    
    def testALResource( self ):       
        ALVerbose.unitTest( "UnitTest ALResource:" )
        
        

        oalResource = ALResource( "test-resource.res", False ) # local file = not in user path
        oalResource.input()
        oalObject = oalResource.getResource( "local_path" )
        ALVerbose.unitTest( "Getting Resource : " + ALString( oalObject ) )
        oalResource.setResource( "local_path", 1000 )
        oalObject = oalResource.getResource( "local_path" )
        ALVerbose.unitTest( "Getting Resource : " + ALString( oalObject ) )
        oalResource.output()

        
        # ASCII
        #oalResource = ALResource( "test-resource-ASCII.res", False ) # local file = not in user path
        #oalResource.setResource( "local_path", 1000 )
        #oalResource.setResource( "banane", "banane" )
        #oalResource.setResource( "pomme", "pomme" )
        #oalResource.outputSerialASCII()
        #
        #oalResource2 = ALResource( "test-resource-ASCII.res", False ) # local file = not in user path
        #oalResource2.inputSerialASCII()         
        #oalObject = oalResource2.getResource( "local_path" )
        #ALVerbose.unitTest( "Getting Resource : " + ALString( oalObject ) )
        #oalObject = oalResource2.getResource( "banane" )
        #ALVerbose.unitTest( "Getting Resource : " + ALString( oalObject ) )
        #oalObject = oalResource2.getResource( "pomme" )
        #ALVerbose.unitTest( "Getting Resource : " + ALString( oalObject ) )

        # XML Only
        oalResource3 = ALResource( "test-resource-XML.xml", False ) # local file = not in user path
        oalResource3.setResource( "local_path", 1000 )
        oalResource3.setResource( "banane", "banane" )
        oalResource3.setResource( "pomme", "pomme" )
        oalResource3.output()
 
        oalResource4 = ALResource( "test-resource-XML.xml", False, False ) # local file = not in user path       
        oalResource4.input()         
        oalObject = oalResource4.getResource( "local_path" )
        ALVerbose.unitTest( "Getting Resource : " + ALString( oalObject ) )
        oalObject = oalResource4.getResource( "banane" )
        ALVerbose.unitTest( "Getting Resource : " + ALString( oalObject ) )
        oalObject = oalResource4.getResource( "pomme" )
        ALVerbose.unitTest( "Getting Resource : " + ALString( oalObject ) )
        
        ALVerbose.unitTest()




##############################################################################
# Module ALDict

class UnitTestALDict( ALTestCase ): 
    def testALDict( self ):
        ALVerbose.unitTest( "Test ALDict" )
        oalDict = ALDict()
        ALVerbose.unitTest( ALString( oalDict ) )
        
        oalDict.add( "banane", 1000 )
        oalDict.add( "pomme", 2000 )
        oalDict.add( "salade", "pomme and outres salades" )
        ALVerbose.unitTest( ALString( oalDict ) )
        
        oalObject = oalDict.get( "banane" )
        ALVerbose.unitTest( ALString( oalObject ) )
        
        oalObject = oalDict.get( "coco" )
        ALVerbose.unitTest( ALString( oalObject ) )

        ALVerbose.unitTest()
        
        
        
##############################################################################
# Module ALStreamSerial

class UnitTestALStreamSerial( ALTestCase ): 
    def testALStreamSerial( self ):
        ALVerbose.unitTest( "Test ALStreamSerial" )
        
        oalStreamName = ALString( "testALStreamSerial.txt" )
        
        oalDict = ALDict()     
        oalDict.add( "dictionary1", 1000 )
        oalDict.add( "dictionary2", 2000 )
        oalDict.add( "dictionary3", "pomme and outres salades" )

  
        oalStreamSerial = ALStreamSerial( oalStreamName, "w" )
        oalDict.output( oalStreamSerial )      
        oalStreamSerial.close()
        
        oalStreamSerial2 = ALStreamSerial( oalStreamName, "r" )   
        oalDict2 =  oalStreamSerial2.input()
        ALVerbose.unitTest( ALString( oalDict2 ) )
             
        ALVerbose.unitTest()
        
        
##############################################################################
# ALStreamXml
class ClassObjectB( ALObject ):
    pass
    
        
class ClassObjectA( ALObject ):
    def __init__( self ):
        ALObject.__init__( self )
        self.m_toto = "toto" + ALString( ALRandom.randInt() )
        self.m_bobo = "bobo" + ALString( ALRandom.randInt() )
        self.objB = ClassObjectB()
         
         
    def outputXml( self, _oalXml, _oalXmlElement ):
        oalXmlElementObject = self.outputXmlObject( _oalXml, _oalXmlElement )    
        
        
        #Forced to use this Dom model!!!!! every time three calls!!!!
        oalXmlElement = _oalXml.createElement( ALToken( "m_toto" ))
        oalXmlElement.appendChild( _oalXml.createTextNode( self.m_toto ) )      
        oalXmlElementObject.appendChild( oalXmlElement )
    
        
        oalXmlElement = _oalXml.createElement( ALToken( "m_bobo" ) )
        oalXmlElement.appendChild( _oalXml.createTextNode( self.m_bobo ) )      
        oalXmlElementObject.appendChild( oalXmlElement )
 
        self.objB.outputXml( _oalXml, oalXmlElementObject )
 
 
    def inputXml( self, _oalXmlElement ):
        
        self.m_toto = "clean"
        self.m_bobo = "clean"
        self.objB = ClassObjectB()
        
        self.inputXmlObject( _oalXmlElement )
       
        self.m_toto = ALXml.getElementTokenValue( _oalXmlElement, ALToken( "m_toto" ) )
        self.m_bobo = ALXml.getElementTokenValue( _oalXmlElement, ALToken( "m_bobo" ) )
                
        objAXmlElement = ALXml.getElementObject( _oalXmlElement, ClassObjectB().getMagicNumber() )
        if (objAXmlElement!=None):
            self.objB.inputXml( objAXmlElement )


class UnitTestALStreamXml( ALTestCase ): 
     
    def replaceFolderModule( self, _oalXml, _oalStrFolderProject ):
       # ALVerbose.screen( "Replacing folder project:  " + _oalStrFolderProject )

        oalAbsolutePath = ALDiskExplorer.absolutePath( ALDiskExplorer.getCurrentFolder() )
        oalAbsolutePath = ALDiskExplorer.addPath( oalAbsolutePath, _oalStrFolderProject )
     
        for inode in _oalXml.getElementsByTagName( "file" ):
            oalXmlNode = inode  
            oalStrFile = ALDiskExplorer.normalize( oalXmlNode.getAttribute( "url" ) )
            if ALFile.isExtension( oalStrFile, ".py" ):
                oalStrFileName = ALFile.getFileName( oalStrFile )
                oalNewName = oalAbsolutePath + "/" + oalStrFileName
                ALVerbose.screen( "Fix:  " + oalNewName )
                oalXmlNode.setAttribute( "url", oalNewName )

        for inode in _oalXml.getElementsByTagName( "string" ):
            oalString = ALString (  inode.getAttribute( "id" ) )
            if oalString=="filename":
                 for jnode in inode.childNodes:
                    if jnode.nodeType==ALXmlNode.TEXT_NODE: 
                        oalStrFile = ALDiskExplorer.normalize( jnode.data )
                        if ALFile.isExtension( oalStrFile, ".py" ):
                            oalStrFileName = ALFile.getFileName( oalStrFile )
                            oalNewName = oalAbsolutePath + "/" + oalStrFileName
                            jnode.data = oalNewName


    def testALStreamXml( self ):
        ALVerbose.unitTest( "UnitTest ALStreamXml:" )
 
        
        oalXml = ALXml( "MyDocumentToWriteInXMLTest" )
        oalXml.addComment( "Test coment" )
        oalXml.addTokenValue( "tokenFirst", "valeur du token si je vais....FIRST" )
        oalXml.addTokenValue( "tokenSecond", "GGHGGHGHG - SECOND" )
        oalXml.addComment( "Test putting together other lines in the comment"  )
        oalXml.addTokenValue( "tokenBANANE", "banane" )
        oalXml.addComment( "Test coment 2" )
        oalXml.output( "test2.xml" )

        oalString = ALString( oalXml.getTokenValue( "tokenSecond" ) )
        ALVerbose.unitTest( "Getting Token tokenSecond: " + oalString )

        oalString = ALString( oalXml.getTokenValue( "tokenBANANE" ) )
        ALVerbose.unitTest( "Getting Token tokenBANANE: " + oalString )



        oalStreamXml = ALStreamXml( "test.xml" )
        oalStreamXml.output( oalXml )
        oalStreamXml.close()

        oalXmlRead = ALXml( "teste-de-leiture")
        oalXmlRead.input( "test2.xml" )
        oalXmlRead.output( "copy.xml" )
        
       # ALVerbose.unitTest( "Forcing an error !!!!! : None")
       # oalXmlRead.close()
        oalString = ALString( oalXmlRead.getTokenValue( "tokenBANANE" ) )
        ALVerbose.unitTest( "Getting Token tokenBANANE in the copy: " + oalString )


        oalXmlRead = ALXml( "test-reading-a-big-file")
        oalXmlRead.input( "input-test.xml" )
        oalXmlRead.output( "test-reading-a-big-file.xml" )
        oalXmlRead.close()


        #oalStreamXml = ALXml()
        #oalStreamXml.input( "input-test.xml"  )
        #oalStreamXml.output( "test-komodo.kpf" )
        #
        #
        #oalXml2 = ALXml( "Super test to parse the tree"  )
        #oalXml2.input( "input-test.xml"  )
        #self.replaceFolderModule( oalXml2, "modules" )
        #oalXml2.output( "test-tree-parse.kpf" )
        
        objA1 = ClassObjectA()
        objA2 = ClassObjectA()
        oalXmlObject = ALXml( "Document-test-object-append")
        oalXmlObject.addComment( "Test of Xml appending new objects " )
        oalXmlObject.addObject( objA1 )
        oalXmlObject.addObject( objA2 )
        oalXmlObject.output( "test-object-append.xml", True )
        oalXmlObject.destroy()
        
        
        # Spikes !!!!!
        oalXmlRead = ALXml()
        oalXmlRead.input(  "test-object-append.xml" )
        oalXmlRead.output( "test-object-append-COPY.xml" )
   
        # Looking for the root
        objAXmlElement = oalXmlRead.getElement( "Document-test-object-append" )
        if (objAXmlElement!=None):
            ALVerbose.unitTest( "Node name: ROOT::" + objAXmlElement.nodeName )
            
            
        # Looking for a unique object - Warning: can returns always the same = first instance only
        objAXmlElement = oalXmlRead.getElement( ClassObjectA().getMagicNumber() )
        if (objAXmlElement!=None):
            ALVerbose.unitTest( "Node name      ::" + ALXml.getElementTokenValue( objAXmlElement, "objectName" ) )
            ALVerbose.unitTest( "Node ID        ::" + ALXml.getElementTokenValue( objAXmlElement, "objectID" ) )
            
            
        # Looking a series of  elements - type list of same objects
        iobjListXmlElement = oalXmlRead.getElementList( ClassObjectA().getMagicNumber() )
        if (iobjListXmlElement!=None):
            for iElement in iobjListXmlElement:
                objAA0 = ClassObjectA()
                objAA0.inputXml( iElement )
                ALVerbose.unitTest( "Node name      ::" + objAA0.getName() )
                ALVerbose.unitTest( "Node ID        ::" + objAA0.getID() )
                ALVerbose.unitTest( "               ::" + objAA0.m_toto )
                ALVerbose.unitTest( "               ::" + objAA0.m_bobo )
                ALVerbose.unitTest( "Sub Node name      ::" + objAA0.objB.getName() )
                ALVerbose.unitTest( "Sub Node ID        ::" + objAA0.objB.getID() )

            
           
        ## spike   
        objAA1 = ClassObjectA()
        objAA1.inputXml( oalXmlRead )
        ALVerbose.unitTest( "Object ID readed from the file : " + objAA1.getMagicNumber() )

        objAA2 = ClassObjectA()
        objAA2.inputXml( oalXmlRead )
        ALVerbose.unitTest( "Object ID readed from the file : " + objAA1.getMagicNumber() )
        
        oalXmlRead.destroy()
        
        
        # Simulates a Crash in the routine
        ALVerbose.unitTest( "Testing the crash of the Xml Parser" )
        oalXmlRead = ALXml()
        oalXmlRead.input( "input-test-ERROR.xml" )
        oalXmlRead.output( "test-reading-a-big-file.xml" )
        oalXmlRead.close()
        
        ALVerbose.unitTest()


##############################################################################
# Module ALSlot

class ClassB :
    def __init__( self ):
        self.m_oalThreadingCondition  = ALThreadingCondition()

    def methodPrintInit( self ):
        self.m_oalThreadingCondition.synchronizeOn()
        ALVerbose.unitTest( "Class B::printing in Init" )
        self.m_oalThreadingCondition.synchronizeOff()
        
    def methodPrintEnd( self ):
        self.m_oalThreadingCondition.synchronizeOn()
        ALVerbose.unitTest( "Class B::printing in END" )
        self.m_oalThreadingCondition.synchronizeOff()
        
    def methodPrintRun( self, _obj = None ):
        self.m_oalThreadingCondition.synchronizeOn()
        ALVerbose.unitTest( "Class B::printing in RUN : " + ALString( _obj ) )
        self.m_oalThreadingCondition.synchronizeOff()
        
    def methodPrintSignal( self, _obj = None  ):
        self.m_oalThreadingCondition.synchronizeOn()
        ALVerbose.unitTest( "Class B::printing in SIGNAL : " + ALString( _obj ) )
        self.m_oalThreadingCondition.synchronizeOff()
        
        
        
class ClassC :
    def __init__( self ):
        self.m_oalThreadingCondition  = ALThreadingCondition()

    def methodPrintRun( self, _obj = None ):
        self.m_oalThreadingCondition.synchronizeOn()
        ALVerbose.unitTest( "Class C::printing in RUN : " + ALString( _obj ) )
        self.m_oalThreadingCondition.synchronizeOff()
        
    def methodPrintSignal( self, _obj = None  ):
        self.m_oalThreadingCondition.synchronizeOn()
        ALVerbose.unitTest( "Class C::printing in SIGNAL : " + ALString( _obj ) )
        self.m_oalThreadingCondition.synchronizeOff()
        
        
        
class ClassA :
    def __init__( self ):
        self.m_slSlotInit = ALSlot()
        self.m_slSlotRun  = ALSlot()
        self.m_slSlotEnd  = ALSlot()
        
    def execute( self ):
        self.m_slSlotInit.call()
        
        self.m_slSlotRun.call()
        for i in range( 0,  1000 ):
            if i==10:
                self.m_slSlotRun.call( i )
            if i==100:
                self.m_slSlotRun.call( None , ALSignal( "signalHundred" ) )       
            if i==500:
                self.m_slSlotRun.call( i , ALSignal( "signalFiveHundred" ) )
            if i==800:
                self.m_slSlotRun.call()
        self.m_slSlotRun.call()
    
        self.m_slSlotEnd.call()
    
    

class UnitTestALSlot( ALTestCase ): 
    def testALSlot( self ):
        ALVerbose.unitTest( "Test ALCallBack + ALSlot" )
        
        oClassB = ClassB()
        oClassC = ClassC()
        
        oClassA = ClassA()
        
        oClassA.m_slSlotInit.connect( oClassB.methodPrintInit )
        oClassA.m_slSlotEnd.connect(  oClassB.methodPrintEnd  )
        
        oClassA.m_slSlotRun.connect(  oClassB.methodPrintRun  )
        oClassA.m_slSlotRun.connect(  oClassB.methodPrintRun,    ALSignal( "signalHundred" ) )
        oClassA.m_slSlotRun.connect(  oClassB.methodPrintSignal, ALSignal( "signalFiveHundred" ) )
        
        oClassA.m_slSlotRun.connect(  oClassC.methodPrintRun,    ALSignal( "signalHundred" ) )
        oClassA.m_slSlotRun.connect(  oClassC.methodPrintSignal, ALSignal( "signalFiveHundred" ) )
       
        oClassA.execute()
        
        ALVerbose.unitTest( )


        
##############################################################################
# ALALCommandLine

class ClassAA:
    def __init__( self ):
        self.m_oalThreadingCondition  = ALThreadingCondition()
        
    def methodFirst( self, _oalObject = None ):
        self.m_oalThreadingCondition.synchronizeOn()
        oalString = ALString( _oalObject )
        ALVerbose.screen( "ClassA::methodFirst -> " + oalString  )
        # Signalizing an error to exit the application
        ALApplicationCommunicator.setSignal( ALSignal.error( "File do not exist :: BATATA in ClassAA::methodFirst" ) )
        self.m_oalThreadingCondition.synchronizeOff()

  
    # Signalizing an error to exit the application
    # ALApplication.setSignal( ALSignal.error() )    
    def executeError( self, _oalObject = None ):
        self.m_oalThreadingCondition.synchronizeOn()
        ALApplication.setSignal( ALSignal.error( "File do not exist :: BATATA in ClassAA::executeError" ) )
        self.m_oalThreadingCondition.synchronizeOff()

        
class ClassBB:
    def __init__( self ):
        self.m_oalThreadingCondition  = ALThreadingCondition()

    def methodFirst( self, _oalObject = None ):
        self.m_oalThreadingCondition.synchronizeOn()
        oalString = ALString( _oalObject )
        ALVerbose.screen( "ClassB::methodFirst -> " + oalString  )
        ALTime.sleep( 5 )
        self.m_oalThreadingCondition.synchronizeOff()


class ClassCC:
    def __init__( self ):
        self.m_oalThreadingCondition  = ALThreadingCondition()

    def methodFirst( self, _oalObject = None ):
        self.m_oalThreadingCondition.synchronizeOn()
        oalString = ALString( _oalObject )
        ALVerbose.screen( "ClassC::methodFirst -> " + oalString )
        self.m_oalThreadingCondition.synchronizeOff()
        

class UnitTestALCommandLine( ALTestCase ): 
    def testALCommandLine( self ):
        ALVerbose.unitTest( "UnitTest ALCommandLine:" )
                  
        oalCommandLineArgument = ALCommandLineArgument( [ "--cB", "--cA", "--cC" ] )
           
        objA = ClassAA()
        objB = ClassBB()
        objC = ClassCC()
             
        oalCommandLine = ALCommandLine( oalCommandLineArgument )
        oalCommandLine.addCommand( "--cA", objA.methodFirst )
        oalCommandLine.addCommand( "--cB", objB.methodFirst )
        oalCommandLine.addCommand( "--cC", objC.methodFirst )
        buu = oalCommandLine.getCommand()
        
        oalCommandLine.execute()
  
  
        if oalCommandLine.existCommand( "--cB" ):
            ALVerbose.unitTest( "Exist command" )
            
        ALVerbose.unitTest()
     
    
        
##############################################################################
# ALApplication
        
class UnitTestALApplication( ALTestCase ): 
    def testALApplication( self ):
        ALVerbose.unitTest( "UnitTest ALApplication:" )
        
        #Workaround to test the application log file in the GLOBAL UnitTest
        oalLogFileTmp = ALVerbose.m_oalLogFile
                 
        objA = ClassAA()
        objB = ClassBB()
        objC = ClassCC()
        # Workaround to have an command line to test the stuffs
       # oalCommandLineArgument = ALCommandLineArgument( [ "--verbose", "--version", "--cB", "1000", "--cA", "file_name.txt", "--cC", "banane" ] )            
       # oalCommandLineArgument = ALCommandLineArgument( [ "--quiet", "--version", "--cB", "1000", "--cA", "file_name.txt", "--cC", "banane" ] )            
        #oalCommandLineArgument = ALCommandLineArgument( [ "-m",  "--cB", "1000", "--cA", "file_name.txt", "--cC", "banane" ] )            
        oalCommandLineArgument = ALCommandLineArgument( [ "--DEBUG", "--cB", "1000", "--cA", "file_name.txt", "--cC", "banane" ] )            
              
               
               
        # Testing Main Framework
        oalApplication = ALApplication( "Application-Test", "0.0.9" )
        
        ALVerbose.unitTest( "Application Name :: " + ALApplication.getApplicationName() )
        
        oalApplication.addListArgument( oalCommandLineArgument )
        
        # FORCING an error to be signalized   
        #oalApplication.addCommand( "--cA", objA.methodFirst )

        oalApplication.addCommand( "--cB", objB.methodFirst )
        oalApplication.addCommand( "--cC", objC.methodFirst )
        
          
        # FORCING an error to be signalized    
       # oalApplication.executeConnect( objA.executeError )
        
        oalApplication.execute()
 
        #
        ## Testing Access to resources
        #oalObject = ALApplication.getResource( "application_last_run" )
        #if (oalObject is not None):
        #    oalStringLastRun = ALString( oalObject );
        #    ALVerbose.screen( "Testing application ressource acces: " + oalStringLastRun )
        #
        #
        ## Testing Access to arguments
        #oalArguments = ALApplication.getCommandLineArguments()
        #oalStringArguments = ALString( oalArguments )
        ##ALVerbose.screen( "Testing application ressource acces: " + oalStringArguments )
        #
        #
        #
        ## Testing Access to command line 
        #ALApplication.addCommandLineArguments( ALList( [ "primeiro_argument"] ))
        #oalArguments = ALApplication.getCommandLineArguments()
        #oalStringArguments = ALString( oalArguments )
        ##ALVerbose.screen( "Testing application ressource acces2: " + oalStringArguments )
        #
        #
        ## Workaround to test the application log file in the GLOBAL UnitTest - end
        #ALVerbose.m_oalLogFile = oalLogFileTmp
        #ALVerbose.unitTest()



##############################################################################
# ALPlugin

class UnitTestALPlugin( ALTestCase ): 
    
    def testALPlugin( self ):
        ALVerbose.unitTest( "UnitTest ALPlugin:" )
        
        oalPlugin = ALPlugin()
        oalPlugin.executePlugin()
        
        ALVerbose.screen( "Test Plugin Token01: " + oalPlugin.getToken() )
        oalPlugin.setToken( "tokenNewPlugin" )  
        ALVerbose.screen( "Test Plugin Token02: " + oalPlugin.getToken() )
        
        ALVerbose.unitTest()
 
 

##############################################################################
# ALPluginFactory

class TestPlugin01( ALPlugin ):
    
    def __init__( self ):
        ALPlugin.__init__( self, "tokenPlugin01" )
        
    def process( self, oalObject = None ):
        ALVerbose.screen( "Running TestPlugin01010101" )



class TestPlugin02( ALPlugin ):
    
    def __init__( self ):
        ALPlugin.__init__( self, "tokenPlugin02" )
        
    def process( self, oalObject = None ):
        ALVerbose.screen( "Running TestPlugin02020202" )

        
    def methodTest( self, oalObject = None ):
        ALVerbose.screen( "Running TestPlugin02020202---TEST" )


class TestPlugin03( ALPlugin ):
           
    def process( self, oalObject = None ):
        ALVerbose.screen( "Running TestPlugin   ||||" + self.getToken() )

class TestPlugin04( TestPlugin03 ):
    pass


class UnitTestALFactoryPlugin( ALTestCase ): 
    
    def testALFactoryPlugin( self ):
        ALVerbose.unitTest( "UnitTest ALFactoryPlugin:" )
    
        oalFactoryPlugin = ALFactoryPlugin()
        oalFactoryPlugin.addPlugin( TestPlugin01() )
        oalFactoryPlugin.addPlugin( TestPlugin02() )
        oalFactoryPlugin.addPlugin( TestPlugin03( "tokenPlugin03" ) )
        oalFactoryPlugin.addPlugin( TestPlugin04( "tokenPlugin04" ) )
        
        oalPlugin = oalFactoryPlugin.getPlugin( "tokenPlugin01" )
        oalPlugin.executePlugin()
        ALVerbose.screen( "Test PluginFactory: " + oalPlugin.getToken() )
        
        oalPlugin = oalFactoryPlugin.getPlugin( "tokenPlugin02" )
        oalPlugin.executePlugin()
        oalPlugin.methodTest()
        ALVerbose.screen( "Test PluginFactory: " + oalPlugin.getToken() )
     
        oalPlugin = oalFactoryPlugin.getPlugin( "tokenPlugin03" )
        oalPlugin.executePlugin()
        ALVerbose.screen( "Test PluginFactory: " + oalPlugin.getToken() )
         
        oalPlugin = oalFactoryPlugin.getPlugin( "tokenPlugin04" )
        oalPlugin.executePlugin()
        ALVerbose.screen( "Test PluginFactory: " + oalPlugin.getToken() )
         
        ALVerbose.unitTest()
 
        
##############################################################################
       
class ALUnitTestKernel( ALUnitTest ):
    def preProcessor( self ):
        #self.addTestMethod( UnitTestALObject().testALObject )
        #self.addTestMethod( UnitTestALLogFile().testALLogFile )
        #self.addTestMethod( UnitTestALVerbose().testALVerbose )
        #self.addTestMethod( UnitTestALStream().testALStream )
        #self.addTestMethod( UnitTestALStreamFile().testALStreamFile )
        #self.addTestMethod( UnitTestALStreamPipe().testALStreamPipe )
        self.addTestMethod( UnitTestALResource().testALResource )
        #self.addTestMethod( UnitTestALDict().testALDict )
        #self.addTestMethod( UnitTestALStreamSerial().testALStreamSerial )
        #self.addTestMethod( UnitTestALStreamXml().testALStreamXml )
        #self.addTestMethod( UnitTestALSlot().testALSlot )
        #self.addTestMethod( UnitTestALCommandLine().testALCommandLine )     
        #self.addTestMethod( UnitTestALApplication().testALApplication )
        #self.addTestMethod( UnitTestALPlugin().testALPlugin )
        #self.addTestMethod( UnitTestALFactoryPlugin().testALFactoryPlugin )

    
##############################################################################

if __name__ == '__main__':

    oalUnitTestKernel = ALUnitTestKernel( "Test Kernel" )
    oalUnitTestKernel.execute()

     
     
