##############################################################################
#
#   File:      unittest_al_classes_communication.py
#
#   Project:   Asynchronous Action Library Project
#              http://aalib.sourceforge.net/
#
#   Author(s): Romeu A. Pieritz & Olof Svensson
#   Contact  : aalib_info@yahoo.com
#
#   Date:      2005/06/24
#
#   License:
#   --------------------------------------------------------------------------
#   Asynchronous Action Library Project
#   Copyright (c) 2005, AALib developers (see above AUTHORS)
#   All rights reserved.
#
#   Redistribution and use in source and binary forms, with or without
#   modification, are permitted provided that the following conditions
#   are met:
#
#   Redistributions of source code must retain the above copyright notice,
#   this list of conditions and the following disclaimer.
#
#   Redistributions in binary form must reproduce the above copyright notice,
#   this list of conditions and the following disclaimer in the documentation
#   and/or other materials provided with the distribution.
#
#   Neither the names of AALib's copyright owner nor the names of its
#   contributors may be used to endorse or promote products derived from
#   this software without specific prior written permission.
#
#   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
#   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
#   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
#   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
#   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
#   TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
#   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
#   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
#   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
#   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
##############################################################################


from al_system  import *
from al_kernel  import *
from al_communication  import *


##############################################################################
# ALMessage

class UnitTestALMessage( ALTestCase ): 
    
    def testALMessage( self ):
        ALVerbose.unitTest( "Test Class ALMessage" )
        message1 = "A message"
        oalmessage1 = ALMessage( message1 )
        ALVerbose.unitTest( oalmessage1.getMessage() )
        message2 = ALString( "A second message" )
        oalmessage2 = ALMessage( message2 )
        ALVerbose.unitTest( oalmessage2.getMessage() )
        ALVerbose.unitTest( )

##############################################################################
# ALMessageCommand

class UnitTestALMessageCommand( ALTestCase ): 
    
    def testALMessageCommand( self ):
        ALVerbose.unitTest( "Test Class ALMessageCommand" )
        message1 = "A message"
        command1 = "A command"
        oalmessagecommand1 = ALMessageCommand( message1, command1 )
        ALVerbose.unitTest( "%s - %s" % ( oalmessagecommand1.getMessage(),
                           oalmessagecommand1.getCommand( ) ) )
        message2 = ALString( "A second message" )
        command2 = ALString( "A second command" )
        oalmessagecommand2 = ALMessageCommand( message2, command2 )
        ALVerbose.unitTest( "%s - %s" % ( oalmessagecommand2.getMessage(),
                           oalmessagecommand2.getCommand( ) ) )
        ALVerbose.unitTest( )

##############################################################################
# ALMessageResponse

#class UnitTestALMessageResponse( ALTestCase ): 
#    
#    def testALMessageResponse( self ):
#        slVerbose = ALVerboseSingleton()
#        ALVerbose.unitTest( "Test Class ALMessageResponse" )
#        message1      = "A response message"
#        path1         = "/path1"
#        errorcode1    = "An error code"
#        errormessage1 = "An error message"
#        oalmessageresponse1 = ALMessageResponse( message1, path1, errorcode1, errormessage1 )
#        ALVerbose.unitTest( "%s - %s - %s - %s" % ( oalmessageresponse1.getMessage(),
#                           oalmessageresponse1.getPath( ),
#                           oalmessageresponse1.getErrorCode( ),
#                           oalmessageresponse1.getErrorMessage( ) ) )
#        message2      = ALString( "A second response message" )
#        path2         = ALString( "/path2" )
#        errorcode2    = ALString( "A second error code" )
#        errormessage2 = ALString( "A second error message" )
#        oalmessageresponse2 = ALMessageResponse( message2, errorcode2, errormessage2 )
#        ALVerbose.unitTest( "%s - %s - %s - %s" % ( oalmessageresponse2.getMessage(),
#                           oalmessageresponse2.getPath( ),
#                           oalmessageresponse2.getErrorCode( ),
#                           oalmessageresponse2.getErrorMessage( ) ) )
#        ALVerbose.unitTest( )
#

##############################################################################
# ALSignal

class UnitTestALSignal( ALTestCase ): 
    
    def testALSignal( self ):
        ALVerbose.unitTest( "Test Class ALSignal" )
        event1 = "eventTestSignal1"
        oalsignal1 = ALSignal( event1 )
        ALVerbose.unitTest( oalsignal1.getSignal() )
        event2 = ALString( "eventTestSignal2" )
        oalsignal2 = ALSignal( event2 )
        ALVerbose.unitTest( oalsignal2.getSignal() )
        ALVerbose.unitTest( )

##############################################################################
# ALManagerSignal

class UnitTestALManagerSignalCallback( ALObject ):
    
    def __init__( self ):
        ALObject.__init__( self )
        
    def callBack( self ):
        ALVerbose.unitTest( "In the UnitTestALManagerSignalCallback" )
        

class UnitTestALManagerSignal( ALTestCase ): 
    
    def testALManagerSignal( self ):
        ALVerbose.unitTest( "Test Class ALManagerSignal" )
        oalManagerSignal = ALManagerSignal()
        event1 = "eventTestSignal1"
        oalsignal1 = ALSignal( event1 )
        oalTest = UnitTestALManagerSignalCallback()
        ALVerbose.unitTest( oalTest.getID() )
        oalManagerSignal.connect( oalTest, oalsignal1,
                                oalTest.callBack )
        oalManagerSignal.emit( oalTest, oalsignal1, None )
        ALVerbose.unitTest( )        
                
        
##############################################################################
# ALMessage

class UnitTestALServerHTTPCallback( ALObject ):
    
    def __init__( self ):
        ALObject.__init__( self )
        
    def callBack( self, _oalmessageresponse ):
        ALVerbose.unitTest( "In the UnitTestALManagerSignalCallback" )
        ALVerbose.unitTest( "Message:       %s" % _oalmessageresponse.getMessage() )
        ALVerbose.unitTest( "Command:       %s" % _oalmessageresponse.getCommand() )
        ALVerbose.unitTest( "Error code:    %s" % _oalmessageresponse.getErrorCode() )
        ALVerbose.unitTest( "Error message: %s" % _oalmessageresponse.getErrorMessage() )
  

class UnitTestALServerHTTP( ALTestCase ): 
    
    def testALServerHTTP( self ):
        ALVerbose.unitTest( "Test Class ALServerHTTP" )
        handler_class  = ALHandlerRequestHTTP
        slObjectCallback = UnitTestALServerHTTPCallback()
        slServerHTTP = ALServerHTTP( "lapmeteor.esrf.fr", 51111 )
        slsignal = ALSignal( "eventServerHTTPRequestPost" )
        ALVerbose.unitTest( "slsignal.getID(): %s" % slsignal.getID() )
        slManagerSignal = ALManagerSignal()
        slManagerSignal.connect( slServerHTTP, slsignal,
                                slObjectCallback.callBack )
        #slServerHTTP.run()
        ALVerbose.unitTest( )


        
                     
        
##############################################################################

class ALUnitTestCommunication( ALUnitTest ):
    def preProcessor( self ):   
        self.addTestMethod( UnitTestALMessage().testALMessage )
        self.addTestMethod( UnitTestALMessageCommand().testALMessageCommand )
        self.addTestMethod( UnitTestALSignal().testALSignal )
        self.addTestMethod( UnitTestALManagerSignal().testALManagerSignal )
        self.addTestMethod( UnitTestALServerHTTP().testALServerHTTP )


##############################################################################
  
if __name__ == '__main__':

    oalUnitTestCommunication = ALUnitTestCommunication( "Test Commnunication" )
    oalUnitTestCommunication.execute()
     


