##############################################################################
#
#   File:      unittest_al_classes_action.py
#
#   Project:   Asynchronous Action Library Project
#              http://aalib.sourceforge.net/
#
#   Author(s): Romeu A. Pieritz & Olof Svensson
#   Contact  : aalib_info@yahoo.com
#
#   Date:      2005/06/24
#
#   License:
#   --------------------------------------------------------------------------
#   Asynchronous Action Library Project
#   Copyright (c) 2005, AALib developers (see above AUTHORS)
#   All rights reserved.
#
#   Redistribution and use in source and binary forms, with or without
#   modification, are permitted provided that the following conditions
#   are met:
#
#   Redistributions of source code must retain the above copyright notice,
#   this list of conditions and the following disclaimer.
#
#   Redistributions in binary form must reproduce the above copyright notice,
#   this list of conditions and the following disclaimer in the documentation
#   and/or other materials provided with the distribution.
#
#   Neither the names of AALib's copyright owner nor the names of its
#   contributors may be used to endorse or promote products derived from
#   this software without specific prior written permission.
#
#   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
#   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
#   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
#   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
#   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
#   TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
#   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
#   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
#   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
#   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
##############################################################################


from al_system  import *
from al_kernel  import *
from al_action  import *


##############################################################################
# ALSignal

class UnitTestALSignal( ALTestCase ): 
    
    def testALSignal( self ):
        ALVerbose.unitTest( "UnitTest ALSignal:" )
          
        oalSignal = ALSignal()
        ALVerbose.unitTest( "Signal      : " + ALString( oalSignal.getSignal() ) )
        ALVerbose.unitTest( "Signal Token: " + ALString( oalSignal.getSignalToken() ) )
 
        oalArgument = ALArgument( [ "--cB", "--cA", "--cC" ] )
        oalSignal.setArgument( oalArgument )
        
        ALVerbose.unitTest( "Signal Argument: " + ALString( oalSignal.getArgument() ) )
        
        oalArgument = ALArgument( [ "--couou", "--error" ] )
        oalSignal = ALSignal.error()
        ALVerbose.unitTest( "Signal      : " + ALString( oalSignal.getSignal() ) )
        ALVerbose.unitTest( "Signal Token: " + ALString( oalSignal.getSignalToken() ) )
        oalSignal.setArgument( oalArgument )
        
        ALVerbose.unitTest( "Signal Argument: " + ALString( oalSignal.getArgument() ) )
        ALVerbose.unitTest( "Signal Argument First: " + ALString( oalSignal.getArgumentNumber() ) )
        oalArgument = oalSignal.getArgument()
        ALVerbose.unitTest( "Fisrt  Argument: " + ALString( oalArgument.getArgumentNumber( 0 ) ) )
  
  
        oalObjectSignal = ALApplication.getSignal()
        ALVerbose.unitTest( "Signal Appli Original  : " + ALString( oalObjectSignal.getSignal() ) )
 
        oalSignalError = ALSignal.error()
        
        ALApplication.setSignal( oalSignalError )
        oalObjectSignal = ALApplication.getSignal()
        ALVerbose.unitTest( "Signal Appli           : " + ALString( oalObjectSignal.getSignal() ) )
  
  
        ALVerbose.unitTest()
 
 
##############################################################################
# Module ALThreadControl + ALAction
     
class ClassBT :
    def __init__( self ):
        self.m_oalThreadingCondition  = ALThreadingCondition()

    def methodPrintInit( self, _obj = None  ):
        self.m_oalThreadingCondition.synchronizeOn()
        ALVerbose.unitTest( "Class B::printing in INIT: " + ALString( _obj ) )
        self.m_oalThreadingCondition.synchronizeOff()
        
    def methodPrintEnd( self, _obj = None  ):
        self.m_oalThreadingCondition.synchronizeOn()
        ALVerbose.unitTest( "Class B::printing in END : " + ALString( _obj ) )
        self.m_oalThreadingCondition.synchronizeOff()
        
    def methodPrintSignal( self, _obj = None  ):
        self.m_oalThreadingCondition.synchronizeOn()
        ALVerbose.unitTest( "Class B::printing in SIGNAL : " + ALString( _obj ) )
        self.m_oalThreadingCondition.synchronizeOff()
        
class ClassCT :
    def __init__( self ):
        self.m_oalThreadingCondition  = ALThreadingCondition()

    def methodPrintRun( self, _obj = None ):
        self.m_oalThreadingCondition.synchronizeOn()
        ALVerbose.unitTest( "Class C::printing in RUN : " + ALString( _obj ) )
        self.m_oalThreadingCondition.synchronizeOff()
        
    def methodPrintSignal( self, _obj = None  ):
        self.m_oalThreadingCondition.synchronizeOn()
        ALVerbose.unitTest( "Class C::printing in SIGNAL : " + ALString( _obj ) )
        self.m_oalThreadingCondition.synchronizeOff()
        
        
class TestALActionScreen( ALAction ):
    
    def __init__( self, _iThreadNo, _fSleepTime ):
        ALAction.__init__( self )
        self.m_iThreadNo  = _iThreadNo
        self.m_fSleepTime = _fSleepTime
        
        
    def process( self ):
        for i in range( 1, 10 ):
            #To force the execption...
            #al_FRAMEWORK_FORCE_EXCEPTION
           
            self.m_oalSlotRun.call( ALString( "bip bip : " + self.getName() ) )
            ALVerbose.unitTest( "Output from " + self.getName() )
            ALTime.sleep( self.m_fSleepTime )
            self.threadControl()
            


class UnitTestALAction( ALTestCase ): 
    def testALAction( self ):
        ALVerbose.unitTest( "Test ALAction" )
        
        oClassBT = ClassBT()
        oClassCT = ClassCT()
        
        oalAction1 = TestALActionScreen( 1, 0.1 )
        oalAction1.setName( "Thread 01" )
        oalAction1.m_oalSlotInit.connect( oClassBT.methodPrintInit )
        oalAction1.m_oalSlotEnd.connect(  oClassBT.methodPrintEnd  )
        oalAction1.m_oalSlotRun.connect(  oClassCT.methodPrintRun  )
        
        oalAction2 = TestALActionScreen( 2, 0.3 )
        oalAction2.setName( "Thread 02" )
        oalAction2.m_oalSlotInit.connect( oClassBT.methodPrintInit )
        oalAction2.m_oalSlotEnd.connect(  oClassBT.methodPrintEnd  )
        oalAction2.m_oalSlotRun.connect(  oClassCT.methodPrintRun  )
       
        oalAction3 = TestALActionScreen( 3, 0.01 )
        oalAction3.setName( "Thread 03" )
        oalAction3.m_oalSlotInit.connect( oClassBT.methodPrintInit )
        oalAction3.m_oalSlotEnd.connect(  oClassBT.methodPrintEnd  )
        oalAction3.m_oalSlotRun.connect(  oClassCT.methodPrintRun  )
       
       
        oalAction1.execute()
       # oalAction1.waitEndOfAction()
        oalAction2.execute()
       # oalAction2.waitEndOfAction()
        
        
        ALTime.sleep( 1 )
        oalAction1.abort()
       
        oalAction3.execute()
        oalAction3.waitEndOfAction()
        
        oalAction2.pause()
        ALTime.sleep( 1.0 )
        oalAction2.resume()
        ALTime.sleep( 0.5 )
        oalAction2.abort()
 
 
        ALVerbose.unitTest( )
 
 
##############################################################################
# Module ALActionSet

class UnitTestALActionSet( ALTestCase ): 
    def testALActionSet( self ):
        ALVerbose.unitTest( "Test ALActionSet Synchronous" )
        
        oClassBT = ClassBT()
        oClassCT = ClassCT()
        
        oalAction1 = TestALActionScreen( 1, 0.1 )
        oalAction1.setName( "Action in Thread 01" )
        oalAction1.m_oalSlotInit.connect( oClassBT.methodPrintInit )
        oalAction1.m_oalSlotEnd.connect(  oClassBT.methodPrintEnd  )
        oalAction1.m_oalSlotRun.connect(  oClassCT.methodPrintRun  )
         
        oalAction2 = TestALActionScreen( 2, 0.3 )
        oalAction2.setName( "Action in Thread 02" )
        oalAction2.m_oalSlotInit.connect( oClassBT.methodPrintInit )
        oalAction2.m_oalSlotEnd.connect(  oClassBT.methodPrintEnd  )
        oalAction2.m_oalSlotRun.connect(  oClassCT.methodPrintRun  )
        
        oalActionSet = ALActionSet()
        oalActionSet.setName( "MainActionSet" )
        oalActionSet.addAction( oalAction1 )
        oalActionSet.addAction( oalAction2 )
       
        oalActionSet.execute()
        ALTime.sleep( 2 )
        oalActionSet.pause()
        ALTime.sleep( 1 )
        oalActionSet.resume()
        ALTime.sleep( 2 )
        oalActionSet.abort()
        
        #oalActionSet.waitEndOfAction() # Needed to unittest run
      
        ALVerbose.unitTest( )

        
        

##############################################################################
# Module ALActionSetAsynchronous

class UnitTestALActionSetAsynchronous( ALTestCase ): 
    def testALActionSetAsynchronous( self ):
        ALVerbose.unitTest( "Test ALActionSet Synchronous" )
        
        oClassBT = ClassBT()
        oClassCT = ClassCT()
        
        oalAction1 = TestALActionScreen( 1, 0.1 )
        oalAction1.setName( "Action in Thread 01" )
        oalAction1.m_oalSlotInit.connect( oClassBT.methodPrintInit )
        oalAction1.m_oalSlotEnd.connect(  oClassBT.methodPrintEnd  )
        oalAction1.m_oalSlotRun.connect(  oClassCT.methodPrintRun  )
         
        oalAction2 = TestALActionScreen( 2, 0.3 )
        oalAction2.setName( "Action in Thread 02" )
        oalAction2.m_oalSlotInit.connect( oClassBT.methodPrintInit )
        oalAction2.m_oalSlotEnd.connect(  oClassBT.methodPrintEnd  )
        oalAction2.m_oalSlotRun.connect(  oClassCT.methodPrintRun  )
        
        oalActionSet = ALActionSet()
        oalActionSet.setName( "MainActionSet" )
        oalActionSet.addAction( oalAction1 )
        oalActionSet.addAction( oalAction2 )
       
        oalActionSet.execute()
        ALTime.sleep( 2 )
        oalActionSet.pause()
        ALTime.sleep( 1 )
        oalActionSet.resume()
        ALTime.sleep( 2 )
        oalActionSet.abort()
        
        #oalActionSet.waitEndOfAction() # Needed to unittest run
      
        ALVerbose.unitTest( )

        
##############################################################################
       
class ALUnitTestAction( ALUnitTest ):
    def preProcessor( self ):    
        #self.addTestMethod( UnitTestALSignal().testALSignal )
        #self.addTestMethod( UnitTestALAction().testALAction )
        #self.addTestMethod( UnitTestALActionSet().testALActionSet )
        self.addTestMethod( UnitTestALActionSetAsynchronous().testALActionSetAsynchronous )

    
##############################################################################

if __name__ == '__main__':

    oalUnitTestAction = ALUnitTestAction( "Test Action" )
    oalUnitTestAction.execute()

     
     
