##############################################################################
#
#   File:      unittest_al_all.py
#
#   Project:   Asynchronous Action Library Project
#              http://aalib.sourceforge.net/
#
#   Author(s): Romeu A. Pieritz & Olof Svensson
#   Contact  : aalib_info@yahoo.com
#
#   Date:      2005/06/24
#
#   License:
#   --------------------------------------------------------------------------
#   Asynchronous Action Library Project
#   Copyright (c) 2005, AALib developers (see above AUTHORS)
#   All rights reserved.
#
#   Redistribution and use in source and binary forms, with or without
#   modification, are permitted provided that the following conditions
#   are met:
#
#   Redistributions of source code must retain the above copyright notice,
#   this list of conditions and the following disclaimer.
#
#   Redistributions in binary form must reproduce the above copyright notice,
#   this list of conditions and the following disclaimer in the documentation
#   and/or other materials provided with the distribution.
#
#   Neither the names of AALib's copyright owner nor the names of its
#   contributors may be used to endorse or promote products derived from
#   this software without specific prior written permission.
#
#   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
#   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
#   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
#   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
#   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
#   TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
#   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
#   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
#   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
#   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
##############################################################################


from unittest_al_classes_kernel             import *
from unittest_al_classes_system             import *
from unittest_al_classes_math               import *
from unittest_al_classes_action             import *
from unittest_al_classes_communication      import *
from unittest_al_classes_script             import *


class ALUnitTestAll( ALUnitTest ):
    def preProcessor( self ):
        self.addTestMethod( ALUnitTestMath( "Test Math" ).execute )
        self.addTestMethod( ALUnitTestSystem( "Test System" ).execute )
        self.addTestMethod( ALUnitTestKernel( "Test Kernel" ).execute )
        self.addTestMethod( ALUnitTestAction( "Test Action" ).execute )
        self.addTestMethod( ALUnitTestCommunication( "Test Communication" ).execute )
        self.addTestMethod( ALUnitTestScript( "Test Script" ).execute )


    def postProcessor( self ):
        ALVerbose.unitTest( "END " + self.getName())
        ALVerbose.unitTest( "Runtime: " + ALString( ALTime.duration() ) + " [s]" )
                   
       
##############################################################################
if __name__ == '__main__':
  
    oalUnitTestAll = ALUnitTestAll( "General Framework UnitTest" )
    oalUnitTestAll.execute()
  
##############################################################################
