##############################################################################
#
#   File:      al_verbose.py
#
#   Project:   Asynchronous Action Library Project
#              http://aalib.sourceforge.net/
#
#   Author(s): Romeu A. Pieritz & Olof Svensson
#   Contact  : aalib_info@yahoo.com
#
#   Date:      2005/06/24
#
#   License:
#   --------------------------------------------------------------------------
#   Asynchronous Action Library Project
#   Copyright (c) 2005, AALib developers (see above AUTHORS)
#   All rights reserved.
#
#   Redistribution and use in source and binary forms, with or without
#   modification, are permitted provided that the following conditions
#   are met:
#
#   Redistributions of source code must retain the above copyright notice,
#   this list of conditions and the following disclaimer.
#
#   Redistributions in binary form must reproduce the above copyright notice,
#   this list of conditions and the following disclaimer in the documentation
#   and/or other materials provided with the distribution.
#
#   Neither the names of AALib's copyright owner nor the names of its
#   contributors may be used to endorse or promote products derived from
#   this software without specific prior written permission.
#
#   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
#   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
#   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
#   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
#   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
#   TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
#   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
#   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
#   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
#   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
##############################################################################



from al_python                import  *
from al_definition            import  *
from al_object                import  ALObject
from al_string                import  ALString
from al_threading_condition   import  ALThreadingCondition
from al_time                  import  ALTime
from al_log_file              import  ALLogFile
from al_multimethod           import  *


class ALVerbose( ALObject ):
    """
    Base class to Verbose
    This class control the information flux between the
    application and the outside world (screen, log files, error, std,
    stderror, etc. )
    
    Note: Designed to be a static class
    Note: Trying to be Thread Safety!!!!
    """

    m_oalThreadingConditionError    = ALThreadingCondition()
    m_oalThreadingConditionUnitTest = ALThreadingCondition()
    m_oalThreadingConditionScreen   = ALThreadingCondition()
    m_oalThreadingConditionLog      = ALThreadingCondition()
    m_oalThreadingConditionLogFile  = ALThreadingCondition()
    m_oalThreadingConditionWrite    = ALThreadingCondition()
    m_oalLogFile = ALLogFile( AL_FRAMEWORK_LOG_NAME )
    m_bIsLogFile = True
    m_bIsVerbose = True
    m_bIsVerboseDebug = False
    m_iindex = 0;


    def __init__( self ):
        ALObject.__init__( self )  
    
    
    def __write( _oalString ):
        ALVerbose.m_oalThreadingConditionWrite.synchronizeOn()
        if ALVerbose.isVerbose() or ALVerbose.isVerboseDebug():
            PySys.stderr.write( ALString( _oalString ) )
        ALVerbose.m_oalThreadingConditionWrite.synchronizeOff()
    __write = staticmethod( __write )
    
        
    def error( _oalString ):
        ALVerbose.m_oalThreadingConditionError.synchronizeOn()
        oalString = ALString( _oalString )
        oalString = ALString( "  [ERROR]: " + oalString + "\n"  )
        # Force the ERROR output in the screen
        btmp = ALVerbose.isVerbose()
        ALVerbose.setVerboseOn()
        ALVerbose.__write( oalString )
        if btmp ==False:
            ALVerbose.setVerboseOff()
        # Force the ERROR output in the screen
        ALVerbose.logFile( oalString )
        ALVerbose.m_oalThreadingConditionError.synchronizeOff()
    error = staticmethod( error )


    def unitTest( _oalString = ALString( "[ ok ]" ) ):
        ALVerbose.m_oalThreadingConditionUnitTest.synchronizeOn()
        oalString = ALString( _oalString )
        oalString = ALString( "  [UnitTest]: " + oalString + "\n" )
        ALVerbose.__write( oalString )
        ALVerbose.logFile( oalString )
        ALVerbose.m_oalThreadingConditionUnitTest.synchronizeOff()
    unitTest = staticmethod( unitTest )
 

    @multimethod( ALString )
    @multimethod( str )
    def screen( _oalString = ALString( "[ ok ]" ) ):
        ALVerbose.m_oalThreadingConditionScreen.synchronizeOn()
        oalString = ALString( _oalString )
        oalString = ALString( "  " + oalString + "\n" )
        ALVerbose.__write( oalString )
        ALVerbose.logFile( oalString )
        ALVerbose.m_oalThreadingConditionScreen.synchronizeOff()
     
     
    @multimethod( float, float )
    @multimethod( int, int )    
    def screen( _fvalue, _fref ):
        ALVerbose.m_oalThreadingConditionScreen.synchronizeOn()
        
        index = ( float(_fvalue)/ float(_fref) )*100.0
    
        if ( index >= ALVerbose.m_iindex+1 ):
            ALVerbose.m_iindex = int( index )
            oalString = ALString( ALVerbose.m_iindex )
            oalString = ALString( "  [ " + oalString + "% ]" + "\n" )
            ALVerbose.__write( oalString )
            ALVerbose.logFile( oalString )
            
        if (index>99.75):  #bug to fix
            ALVerbose.m_iindex = 0
                        
        ALVerbose.m_oalThreadingConditionScreen.synchronizeOff()
               
    screen = staticmethod( screen )


   
   
    @multimethod( ALString )
    @multimethod( str )
    def DEBUG( _oalString = ALString( " DEBUG mode " ) ):
        if ALVerbose.isVerboseDebug():
            ALVerbose.screen( ALString( "[DEBUG]: " + _oalString ) )
        
    @multimethod( float, float )
    @multimethod( int, int )    
    def DEBUG( _fvalue, _fref ):
        if ALVerbose.isVerboseDebug():
            ALVerbose.screen( _fvalue, _fref )
    DEBUG = staticmethod( DEBUG )





    # Private Method
    def logFile( _oalString ):
        if ALVerbose.m_bIsLogFile == False:
            return
        ALVerbose.m_oalThreadingConditionLogFile.synchronizeOn()
        ALVerbose.m_oalLogFile.log( ALString(  _oalString ) )
        ALVerbose.m_oalThreadingConditionLogFile.synchronizeOff()
    logFile = staticmethod( logFile )



    def log( _oalString ):
        ALVerbose.m_oalThreadingConditionLog.synchronizeOn()
        oalString = ALString( _oalString )
        oalString = ALString( "  " + oalString + "\n" )
        ALVerbose.logFile( oalString )
        ALVerbose.m_oalThreadingConditionLog.synchronizeOff()
    log = staticmethod( log )


    def setLogFileOn( ):
        ALVerbose.m_oalThreadingConditionLog.synchronizeOn()
        ALVerbose.m_bIsLogFile = True
        ALVerbose.m_oalThreadingConditionLog.synchronizeOff()
    setLogFileOn = staticmethod( setLogFileOn )
        
        
    def setLogFileOff( ):
        ALVerbose.m_oalThreadingConditionLog.synchronizeOn()
        ALVerbose.m_bIsLogFile = False
        ALVerbose.m_oalThreadingConditionLog.synchronizeOff()
    setLogFileOff = staticmethod( setLogFileOff )


    def setLogFileName( _oalString ):
        ALVerbose.m_oalThreadingConditionLog.synchronizeOn()
        ALVerbose.m_oalLogFile.setFileName( _oalString )
        ALVerbose.m_oalThreadingConditionLog.synchronizeOff()
    setLogFileName = staticmethod( setLogFileName )
    
    
    def getLogFileName( _oalString ):
        ALVerbose.m_oalThreadingConditionLog.synchronizeOn()
        oalString = ALVerbose.m_oalLogFile.getFileName()
        ALVerbose.m_oalThreadingConditionLog.synchronizeOff()
        return oalString
    getLogFileName = staticmethod( getLogFileName )


    def isVerbose():
        ALVerbose.m_oalThreadingConditionLog.synchronizeOn()
        bisVerbose = ALVerbose.m_bIsVerbose
        ALVerbose.m_oalThreadingConditionLog.synchronizeOff()
        return bisVerbose
    isVerbose = staticmethod( isVerbose )


    def setVerboseOn( ):
        ALVerbose.m_oalThreadingConditionLog.synchronizeOn()
        ALVerbose.m_bIsVerbose = True
        ALVerbose.m_oalThreadingConditionLog.synchronizeOff()
    setVerboseOn = staticmethod( setVerboseOn )
        
        
    def setVerboseOff( ):
        ALVerbose.m_oalThreadingConditionLog.synchronizeOn()
        ALVerbose.m_bIsVerbose = False
        ALVerbose.m_oalThreadingConditionLog.synchronizeOff()
    setVerboseOff = staticmethod( setVerboseOff )


    def isVerboseDebug():
        ALVerbose.m_oalThreadingConditionLog.synchronizeOn()
        bisVerboseDebug = ALVerbose.m_bIsVerboseDebug
        ALVerbose.m_oalThreadingConditionLog.synchronizeOff()
        return bisVerboseDebug
    isVerboseDebug = staticmethod( isVerboseDebug )


    def setVerboseDebugOn( ):
        ALVerbose.m_oalThreadingConditionLog.synchronizeOn()
        ALVerbose.m_bIsVerboseDebug = True
        ALVerbose.m_oalThreadingConditionLog.synchronizeOff()
    setVerboseDebugOn = staticmethod( setVerboseDebugOn )
        
        
    def setVerboseDebugOff( ):
        ALVerbose.m_oalThreadingConditionLog.synchronizeOn()
        ALVerbose.m_bIsVerboseDebug = False
        ALVerbose.m_oalThreadingConditionLog.synchronizeOff()
    setVerboseDebugOff = staticmethod( setVerboseDebugOff )




##############################################################################


       