##############################################################################
#
#   File:      al_trace.py
#
#   Project:   Asynchronous Action Library Project
#              http://aalib.sourceforge.net/
#
#   Author(s): Romeu A. Pieritz & Olof Svensson
#   Contact  : aalib_info@yahoo.com
#
#   Date:      2005/06/24
#
#   License:
#   --------------------------------------------------------------------------
#   Asynchronous Action Library Project
#   Copyright (c) 2005, AALib developers (see above AUTHORS)
#   All rights reserved.
#
#   Redistribution and use in source and binary forms, with or without
#   modification, are permitted provided that the following conditions
#   are met:
#
#   Redistributions of source code must retain the above copyright notice,
#   this list of conditions and the following disclaimer.
#
#   Redistributions in binary form must reproduce the above copyright notice,
#   this list of conditions and the following disclaimer in the documentation
#   and/or other materials provided with the distribution.
#
#   Neither the names of AALib's copyright owner nor the names of its
#   contributors may be used to endorse or promote products derived from
#   this software without specific prior written permission.
#
#   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
#   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
#   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
#   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
#   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
#   TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
#   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
#   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
#   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
#   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
##############################################################################


from al_python                  import *
from al_object                  import ALObject
from al_sys                     import ALSystem
from al_verbose                 import ALVerbose
from al_string                  import ALString
from al_disk_explorer           import ALDiskExplorer

     
class ALTrace( ALObject ):
    """
    Interface for AL trace objects.
    """
    def __init__( self ):
        ALObject.__init__( self )
    
     
    def trace( _oalObject = None ):
        """
        This method to trace the data.
        """
        if (_oalObject != None):
            oalString = ALString( _oalObject.getName() + "::EXCEPTION" )  
            ALVerbose.error( oalString )
            oalString = ALString( "EXCEPTION objectID:: " + _oalObject.getID() )  
            ALVerbose.error( oalString )
            
        (exc_type, exc_value, exc_traceback) = ALSystem.exc_info()
        list = PyTraceback.extract_tb( exc_traceback )
        for line in list:
            ALVerbose.error( "File  :: " + ALString( ALDiskExplorer.normPath( line[0] ) ) )
            ALVerbose.error( "Method:: " + ALString( line[2] ) )
            ALVerbose.error( "Line  :: " + ALString( line[1] ) )
            ALVerbose.error( "Object:: " + ALString( line[3] ) )           
        oalStringErrorMessage = ALString( PyTraceback.format_exception_only( exc_type, exc_value )[0][:-1] )
        ALVerbose.error( oalStringErrorMessage )
        exc_traceback = None
    trace = staticmethod( trace )
    


##############################################################################