##############################################################################
#
#   File:      al_time.py
#
#   Project:   Asynchronous Action Library Project
#              http://aalib.sourceforge.net/
#
#   Author(s): Romeu A. Pieritz & Olof Svensson
#   Contact  : aalib_info@yahoo.com
#
#   Date:      2005/06/24
#
#   License:
#   --------------------------------------------------------------------------
#   Asynchronous Action Library Project
#   Copyright (c) 2005, AALib developers (see above AUTHORS)
#   All rights reserved.
#
#   Redistribution and use in source and binary forms, with or without
#   modification, are permitted provided that the following conditions
#   are met:
#
#   Redistributions of source code must retain the above copyright notice,
#   this list of conditions and the following disclaimer.
#
#   Redistributions in binary form must reproduce the above copyright notice,
#   this list of conditions and the following disclaimer in the documentation
#   and/or other materials provided with the distribution.
#
#   Neither the names of AALib's copyright owner nor the names of its
#   contributors may be used to endorse or promote products derived from
#   this software without specific prior written permission.
#
#   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
#   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
#   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
#   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
#   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
#   TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
#   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
#   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
#   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
#   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
##############################################################################


from al_python                  import PyTime
from al_string                  import ALString
from al_object                  import ALObject
from al_multimethod             import  *


class ALTime( ALObject ):
    """
    Interface for AL time objects.
    
    """
    m_fTimeInit = 0.0
    m_fTimeEnd  = 1.0
    
    def __init__( self ):
        ALObject.__init__( self )
 
 
    def time():
        return PyTime.time()
    time = staticmethod( time )
    
    def clock():
        return PyTime.clock()
    clock = staticmethod( clock )


    def date():
        osltimestring = ALString( PyTime.strftime( "%Y%m%d", PyTime.localtime( PyTime.time() ) ) )
        return osltimestring
    date = staticmethod( date )
    

    def hour():
        osltimestring = ALString( PyTime.strftime( "%H:%M:%S", PyTime.localtime( PyTime.time() ) ) )
        return osltimestring
    hour = staticmethod( hour )
    

    @multimethod()
    def timeString():
        osltimestring = ALString( PyTime.strftime( "[ %Y/%m/%d %H:%M:%S ]", PyTime.localtime( PyTime.time() ) ) )
        return osltimestring
    
    @multimethod( float )   
    def timeString( _fvalue ):
        osltimestring = ALString( PyTime.strftime( "[ %Y/%m/%d %H:%M:%S ]", PyTime.localtime( _fvalue ) ) )
        return osltimestring
    timeString = staticmethod( timeString )

   
    def sleep( _fTimeInSeconds = 1 ):
        PyTime.sleep( _fTimeInSeconds )
    sleep = staticmethod( sleep )

 
    def init():
        """
        Set the time in seconds
        """
        ALTime.m_fTimeInit = ALTime.clock()
        return ALTime.m_fTimeInit
    init = staticmethod( init )


    def end():
        """
        Set the time in seconds
        """
        ALTime.m_fTimeEnd = ALTime.clock()
        return ALTime.m_fTimeEnd
    end = staticmethod( end )


    def duration():
        """
        Return the time in seconds
        """
        return ALTime.end()
    duration = staticmethod( duration )


    def dif():
        """
        Return the time in seconds
        """
        ALTime.end()
        fdif = ALTime.m_fTimeEnd - ALTime.m_fTimeInit
        ALTime.init()
        return fdif
    dif = staticmethod( dif )


    
##############################################################################
   