##############################################################################
#
#   File:      al_sys.py
#
#   Project:   Asynchronous Action Library Project
#              http://aalib.sourceforge.net/
#
#   Author(s): Romeu A. Pieritz & Olof Svensson
#   Contact  : aalib_info@yahoo.com
#
#   Date:      2005/06/24
#
#   License:
#   --------------------------------------------------------------------------
#   Asynchronous Action Library Project
#   Copyright (c) 2005, AALib developers (see above AUTHORS)
#   All rights reserved.
#
#   Redistribution and use in source and binary forms, with or without
#   modification, are permitted provided that the following conditions
#   are met:
#
#   Redistributions of source code must retain the above copyright notice,
#   this list of conditions and the following disclaimer.
#
#   Redistributions in binary form must reproduce the above copyright notice,
#   this list of conditions and the following disclaimer in the documentation
#   and/or other materials provided with the distribution.
#
#   Neither the names of AALib's copyright owner nor the names of its
#   contributors may be used to endorse or promote products derived from
#   this software without specific prior written permission.
#
#   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
#   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
#   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
#   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
#   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
#   TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
#   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
#   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
#   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
#   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
##############################################################################


from al_python  import PySys
from al_python  import PyOS
from al_python  import PyPlatform
from al_python  import PySocket
from al_python  import PyGetPass
from al_python  import PyStat
from al_object  import ALObject
from al_string  import ALString
 
       
class ALSystem( ALObject ):
    """
    Interface to the System parameters
        
    Note: Designed to be a Singleton
    """
    def __init__( ALSystem ):
       ALObject.__init__( ALSystem )


    def getPid():
        return PyOS.getpid()
    getPid = staticmethod( getPid ) 

    def exit( _iArg = 1 ):
        PySys.exit( _iArg )
    exit = staticmethod( exit )
    
    def exc_info():
        return PySys.exc_info()
    exc_info = staticmethod( exc_info )
   

   # def executeProcess(  _pathExe, _argList = [], _mode = PyOS.P_NOWAIT ):
   #     oList = [ " ", " "  ] # to fix an error in win32 version
   #     for i in _argList:
   #         oList.append( i )
   #     PyOS.spawnv( _mode, _pathExe,  _argList ) 
   # executeProcess= staticmethod( executeProcess )
    def executeProcess(  _pathExe, _arg = " " , _mode = PyOS.P_NOWAIT ):
        oList = [ " ", _arg  ] # to fix an error in win32 version
        PyOS.spawnv( _mode, _pathExe,  oList ) 
    executeProcess= staticmethod( executeProcess )

    
    def openPipe( _command ):
        return PyOS.popen( _command )
    openPipe= staticmethod( openPipe )
    
    
    def execute( _oalString ):
     #   PyOS.system( "./" + _oalString )
      #  PyOS.chmod(  _oalString, PyStat.S_IRWXU )
        PyOS.system( _oalString )
    execute= staticmethod( execute )
          
          
    # used to bypass the cygwin bug only 
    def getOSControl( ):
        oalString = None
        if PyOS.name =="nt":
            oalString = ALString( "WindowsSystem" )
        elif PyOS.name == "posix" :
            oalStrSystem = PyOS.uname()
            if oalStrSystem[0] == "Linux" :
                oalString = ALString( "LinuxSystem" )
            elif oalStrSystem[0] == "SunOS" :
                oalString = ALString( "SunSystem" )
            elif oalStrSystem[0] != "Linux" :
                oalStrPath = PyOS.getcwd()
                if oalStrPath.count("cygdrive") == True :
                    oalString = ALString( "WindowsCygwinSystem" )
                else :
                   # ALVerbose.error( "AALib::NOT TESTED AND VALIDATED = Unknown Operational System" )
                    print " [ERROR] AALib::NOT TESTED AND VALIDATED in this Unknown Operational System\n"
                    PySys.exit()
        return oalString
    getOSControl = staticmethod( getOSControl )
    
           
    def getOSName( ):
        oalString = None
        if ALSystem.getOSControl() == ALString( "WindowsSystem" ):
            oalString = ALString( "Windows" )
        elif ALSystem.getOSControl() == ALString( "LinuxSystem" ):
            oalString = ALString( "Linux" )
        elif ALSystem.getOSControl() == ALString( "WindowsCygwinSystem" ):
            oalString = ALString( "Windows" )
        elif ALSystem.getOSControl() == ALString( "SunSystem" ):
            oalString = ALString( "Sun" )
        return oalString
    getOSName = staticmethod( getOSName ) 
    
        
    def getOSType():
        oalString = None
        if ALSystem.getOSControl() == ALString( "WindowsSystem" ):
            oalString = ALString( PyPlatform.uname()[2] )
        elif ALSystem.getOSControl() == ALString( "LinuxSystem" ):
            oalString = ALString( PyOS.uname()[2] )
        elif ALSystem.getOSControl() == ALString( "SunSystem" ):
            oalString = ALString( PyOS.uname()[2] )
        elif ALSystem.getOSControl() == ALString( "WindowsCygwinSystem" ):
            oalString = ALString( "Cygwin" )
        return oalString
    getOSType = staticmethod( getOSType )
        
        
    def getUName( ):
        if ALSystem.getOSControl() == ALString( "WindowsSystem" ):
            return PyPlatform.uname()
        elif ALSystem.getOSControl() == ALString( "LinuxSystem" ):
            return PyOS.uname()
        elif ALSystem.getOSControl() == ALString( "SunSystem" ):
            return PyOS.uname()
        elif ALSystem.getOSControl() == ALString( "WindowsCygwinSystem" ):
            return PyOS.uname()
    getUName = staticmethod( getUName )
    
      
    def getHostName( ):
        oalString = None
        if ALSystem.getOSControl() == ALString( "WindowsSystem" ):
            oalString = ALString( PyPlatform.uname()[1] )
        elif ALSystem.getOSControl() == ALString( "LinuxSystem" ):
            oalString = ALString( PyOS.uname()[1] )
        elif ALSystem.getOSControl() == ALString( "SunSystem" ):
            oalString = ALString( PyOS.uname()[1] )
        elif ALSystem.getOSControl() == ALString( "WindowsCygwinSystem" ):
            oalString = ALString( PyOS.uname()[1] )
        return oalString
    getHostName = staticmethod( getHostName )
    
    
    def getOSVersion():
        oalString =  None
        if ALSystem.getOSControl() == ALString( "WindowsSystem" ):
            oalString = ALString( PyPlatform.uname()[3] )
        elif ALSystem.getOSControl() == ALString( "LinuxSystem" ):
            oalString = ALString( PyOS.uname()[2] )
        elif ALSystem.getOSControl() == ALString( "SunSystem" ):
            oalString = ALString( PyOS.uname()[2] )
        elif ALSystem.getOSControl() == ALString( "WindowsCygwinSystem" ):
            oalString = ALString( PyOS.uname()[2] )
        return oalString
    getOSVersion = staticmethod( getOSVersion )
    
    
    def getMachineVersion():
        oalString = None
        if ALSystem.getOSControl() == ALString( "WindowsSystem" ):
            oalString = ALString( "i686" )
        elif ALSystem.getOSControl() == ALString( "LinuxSystem" ):
            oalString = ALString( PyOS.uname()[4] )
        elif ALSystem.getOSControl() == ALString( "SunSystem" ):
            oalString = ALString( PyOS.uname()[4] )
        elif ALSystem.getOSControl() == ALString( "WindowsCygwinSystem" ):
            oalString = ALString( PyOS.uname()[4] )
        return oalString
    getMachineVersion = staticmethod( getMachineVersion )
    
    
    def getUserName():
        return ALString( PyGetPass.getuser() )
    getUserName = staticmethod( getUserName )
    
    
    def getHostIP():
        return ALString( PySocket.gethostbyname( PySocket.gethostname() ) )
    getHostIP = staticmethod( getHostIP ) 
    
    def getHost():
        return ALString(  PySocket.getfqdn()  )
    getHost = staticmethod( getHost )
    
    def getCwd():
        oalString = ALString( PyOS.getcwd() )
        oalString = oalString.replace( "\\", "/" )
        return oalString
    getCwd = staticmethod( getCwd )
    
    def getCurrentFolder():      
        return ALSystem.getCwd()
    getCurrentFolder = staticmethod( getCurrentFolder )
    

    def getProgramName( ):
        oalString = ALString( PySys.argv[0] )
        oalString = oalString.replace( "\\", "/" )
        return oalString
    getProgramName = staticmethod( getProgramName )
    
    
    def getCompilerName():
        oalString = ALString( "Python " + ALString( PySys.version ) )
        oalString = oalString.replace( "\n", " " )
        return oalString
    getCompilerName = staticmethod( getCompilerName )
    
    
    
    def getUserPath( ):
        oalString = ALString( PyOS.path.expanduser("~") )
        oalString = oalString.replace( "\\", "/" )
        if ALSystem.getOSControl() == ALString( "WindowsCygwinSystem" ):
            if oalString.count("cygdrive") == True :
                lstr = oalString[10]           
                oalStringPath = ALString.replace( oalString, "/cygdrive/" + lstr + "/", lstr + ":/" )
                oalString = oalStringPath 
        return oalString;
    getUserPath = staticmethod( getUserPath )
  

 
##############################################################################
