##############################################################################
#
#   File:      al_string.py
#
#   Project:   Asynchronous Action Library Project
#              http://aalib.sourceforge.net/
#
#   Author(s): Romeu A. Pieritz & Olof Svensson
#   Contact  : aalib_info@yahoo.com
#
#   Date:      2005/06/24
#
#   License:
#   --------------------------------------------------------------------------
#   Asynchronous Action Library Project
#   Copyright (c) 2005, AALib developers (see above AUTHORS)
#   All rights reserved.
#
#   Redistribution and use in source and binary forms, with or without
#   modification, are permitted provided that the following conditions
#   are met:
#
#   Redistributions of source code must retain the above copyright notice,
#   this list of conditions and the following disclaimer.
#
#   Redistributions in binary form must reproduce the above copyright notice,
#   this list of conditions and the following disclaimer in the documentation
#   and/or other materials provided with the distribution.
#
#   Neither the names of AALib's copyright owner nor the names of its
#   contributors may be used to endorse or promote products derived from
#   this software without specific prior written permission.
#
#   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
#   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
#   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
#   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
#   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
#   TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
#   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
#   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
#   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
#   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
##############################################################################



from al_python import *


class ALString( str ):
    """
    Interface for AL string objects.
    """
    
    
    def __init__( self, _ostr = None ):
        str.__init__( str( _ostr ) )
  
  
    def duplicate( self ):
        """
        This method is normally provided by the ESObject base class but
        since we don't inherit from ESObject we must define this method
        explicitly.
        """
        return ALString( self )


    def equals( self, _ostr ):
        """
        a.equals(b) corresponds to (a == b) in Python.
        """
        return ( str( self ) == str( _ostr ) )
    
    
    def atoi( self ):
        """
        Returns an integer.
        """
        return PyString.atoi( str( self ) )
    
  
    def atof( self ):
        """
        Returns a float.
        """
        return PyString.atof( str( self ) )
    

    def replace( self, _ostr1, _ostr2, _iMaxcount = -1 ):
        """
        Overrides the str replace method.
        """
        return ALString( str.replace( str( self ), _ostr1, _ostr2, _iMaxcount ) )


    def capitalize( self ):
        """
        Returns a string with the first letter capitalized and all other letters small.
        """
        return PyString.capitalize( str( self ) )
    
    
    def cleanXml( self ):
        """
        Returns a string with the first letter capitalized and all other letters small.
        """
        self = self.replace( "\n", "" )
        self = self.replace( "\t", "" )
        return ALString( self )
    
  
    def split( self, _oCharater ):
        """
        """
        oList = str.split( self, _oCharater  )
        return oList
    

##############################################################################
