##############################################################################
#
#   File:      al_stream_xml.py
#
#   Project:   Asynchronous Action Library Project
#              http://aalib.sourceforge.net/
#
#   Author(s): Romeu A. Pieritz & Olof Svensson
#   Contact  : aalib_info@yahoo.com
#
#   Date:      2005/06/24
#
#   License:
#   --------------------------------------------------------------------------
#   Asynchronous Action Library Project
#   Copyright (c) 2005, AALib developers (see above AUTHORS)
#   All rights reserved.
#
#   Redistribution and use in source and binary forms, with or without
#   modification, are permitted provided that the following conditions
#   are met:
#
#   Redistributions of source code must retain the above copyright notice,
#   this list of conditions and the following disclaimer.
#
#   Redistributions in binary form must reproduce the above copyright notice,
#   this list of conditions and the following disclaimer in the documentation
#   and/or other materials provided with the distribution.
#
#   Neither the names of AALib's copyright owner nor the names of its
#   contributors may be used to endorse or promote products derived from
#   this software without specific prior written permission.
#
#   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
#   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
#   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
#   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
#   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
#   TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
#   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
#   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
#   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
#   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
##############################################################################



from al_python      import *
from al_stream      import ALStream
from al_xml         import ALXml



class ALStreamXml( ALStream ):
    """
    Class for XML streams

    """
    
        
    def __init__( self, _oalString, _oalStringFlag = "w" ):
        ALStream.__init__( self, _oalString )
        self.m_oalStreamFlag = _oalStringFlag
        self.m_bIsOpen = False
        self.m_oalStream = None
        if ( self.m_oalStreamFlag == "w" ):
            self.m_oalStream = open( self.m_oalStreamName, self.m_oalStreamFlag )
            self.m_bIsOpen = True;
    
   
    def read( self ):
        self.synchronizeOn()
        oalXml = ALXml.createXml( self.m_oalStreamName )
        self.synchronizeOff()
        return oalXml
    
    
    def write( self, _oalObject ):
        self.synchronizeOn()
        if ( self.m_oalStreamFlag=="w"):
            # Workaround in from the heritance problem from xml.minidom classes
            # Fixed but necessary to Python legacy stuff
            if ( isinstance( _oalObject, ALXml ) or isinstance( _oalObject, PyXmlDocument) ):
                #self.m_oalStream.write( _oalObject.toprettyxml( "\t", "\n", "utf-8" ) ) # bug in Komodo project file
                self.m_oalStream.write( _oalObject.toxml( "utf-8" ) )
        self.synchronizeOff()

 
 
    # Standart IO
    def input( self ):
        return self.read()
    
    
    def output( self, _oalObject ):
        self.write( _oalObject )



##############################################################################
  