##############################################################################
#
#   File:      al_callback.py
#
#   Project:   Asynchronous Action Library Project
#              http://aalib.sourceforge.net/
#
#   Author(s): Romeu A. Pieritz & Olof Svensson
#   Contact  : aalib_info@yahoo.com
#
#   Date:      2005/06/24
#
#   License:
#   --------------------------------------------------------------------------
#   Asynchronous Action Library Project
#   Copyright (c) 2005, AALib developers (see above AUTHORS)
#   All rights reserved.
#
#   Redistribution and use in source and binary forms, with or without
#   modification, are permitted provided that the following conditions
#   are met:
#
#   Redistributions of source code must retain the above copyright notice,
#   this list of conditions and the following disclaimer.
#
#   Redistributions in binary form must reproduce the above copyright notice,
#   this list of conditions and the following disclaimer in the documentation
#   and/or other materials provided with the distribution.
#
#   Neither the names of AALib's copyright owner nor the names of its
#   contributors may be used to endorse or promote products derived from
#   this software without specific prior written permission.
#
#   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
#   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
#   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
#   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
#   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
#   TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
#   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
#   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
#   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
#   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
##############################################################################



from al_python              import *
from al_manager             import ALManager
from al_threading_condition import ALThreadingCondition
from al_list                import ALList
from al_signal              import ALSignal


class ALSlot( ALManager ):
    """
    Class for managing signals.
    """
    
    
    def __init__( self ):
        ALManager.__init__( self )
        self.m_oalListConnection = ALList()
        self.m_oalThreadingConditionSlot = ALThreadingCondition()


    def connect(self, _oalClassMethod, _oalSignal = None ):
        """
        Connects a signal between an object and a method in an other object.
        """      
        if ( _oalClassMethod is None ):
            raise "RunTimeException", "ALManagerSignal: _oalClassMethod is None"    
        self.m_oalThreadingConditionSlot.synchronizeOn()    # Block the thread
        self.m_oalListConnection.append( [ _oalSignal, _oalClassMethod ] )      
        self.m_oalThreadingConditionSlot.synchronizeOff()   # Release the thread

    
    # Blocked by self.call()
    def executeMethod( self, _method, _oalListArguments = None ):
        if _oalListArguments is None:
            _method()    
        else:
            _method( _oalListArguments )

    
    
    def call( self, _oalListArguments = None, _oalSignal = None ):   
        self.m_oalThreadingConditionSlot.synchronizeOn()    # Block the thread
        for connection in self.m_oalListConnection:
            oalSignal = connection[ 0 ]
            omethod   = connection[ 1 ]
            if _oalSignal is None:
                if oalSignal is None:
                    self.executeMethod( omethod, _oalListArguments )
            else: 
                if oalSignal is not None:
                    oalStringSignalExt = _oalSignal.getSignal()
                    oalStringSignal    =  oalSignal.getSignal()
                    if oalStringSignal.equals( oalStringSignalExt ):
                        if _oalListArguments == None :
                            self.executeMethod( omethod, _oalSignal )
                        else :
                            self.executeMethod( omethod, _oalListArguments )
                       
        self.m_oalThreadingConditionSlot.synchronizeOff()   # Release the thread


    def callSignal( self, _oalSignal ):
        self.call( None, _oalSignal )

##############################################################################

    
   
