##############################################################################
#
#   File:      al_signal.py
#
#   Project:   Asynchronous Action Library Project
#              http://aalib.sourceforge.net/
#
#   Author(s): Romeu A. Pieritz & Olof Svensson
#   Contact  : aalib_info@yahoo.com
#
#   Date:      2005/06/24
#
#   License:
#   --------------------------------------------------------------------------
#   Asynchronous Action Library Project
#   Copyright (c) 2005, AALib developers (see above AUTHORS)
#   All rights reserved.
#
#   Redistribution and use in source and binary forms, with or without
#   modification, are permitted provided that the following conditions
#   are met:
#
#   Redistributions of source code must retain the above copyright notice,
#   this list of conditions and the following disclaimer.
#
#   Redistributions in binary form must reproduce the above copyright notice,
#   this list of conditions and the following disclaimer in the documentation
#   and/or other materials provided with the distribution.
#
#   Neither the names of AALib's copyright owner nor the names of its
#   contributors may be used to endorse or promote products derived from
#   this software without specific prior written permission.
#
#   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
#   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
#   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
#   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
#   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
#   TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
#   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
#   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
#   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
#   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
##############################################################################


from al_definition      import *
from al_object          import ALObject
from al_string          import ALString
from al_argument        import ALArgument


class ALSignal( ALObject ):
    """
    Base class for signal objects.
    """
    
    
    def __init__( self, _oalString = None, _oalArgument = None ):
        ALObject.__init__( self )
        self.m_oalStringInformation = None
        self.m_oalStringSignal = None
        self.m_oalArgument = None
        
        self.setSignal( _oalString )
        if isinstance( _oalArgument, ALArgument ) :
            self.setArgument( _oalArgument )
        else :
            self.setInformation( ALString( _oalArgument ) )
 
  
    def setSignal( self, _oalString ):
        if _oalString is None:
            self.m_oalStringSignal = None
        else:
            self.m_oalStringSignal = ALString( _oalString )
    
 
    def setArgument( self, _oalArgument ):
        if _oalArgument is None:
            self.m_oalArgument = None
        else:
            self.m_oalArgument = ALArgument( _oalArgument )
    
      
    def getArgument( self ):
        """
        @return: A copy of the signal argument
        """
        return self.m_oalArgument
    
         
    def getArgumentNumber( self, _i = 0 ):
        """
        @return: A copy of the  i argument 
        """
        if self.m_oalArgument != None:
            return self.m_oalArgument.getArgumentNumber( _i )
        else:
            return None
 
    
    def getSignal( self ):
        """
        @return: A copy of the signal string
        """
        return self.m_oalStringSignal # to use with None signal
    
  
    def getSignalToken( self ):
        """
        @return: A copy of the signal string
        """
        return self.getSignal()
    
   
    def getInformation( self ):
        """
        @return: Get an information string
        """
        return self.m_oalStringInformation
    
    
    def setInformation( self, _oalString ):
        """
        @return: Set an information string
        """
        self.m_oalStringInformation  = ALString( _oalString )
    
   
    
    # Static Methods #########################################################
    def ok( _oalString = None ):
        return ALSignal( AL_SIGNAL_OK, _oalString  )
    ok = staticmethod( ok )
    
    
    def error( _oalString = None ):
        return ALSignal( AL_ACTION_SIGNAL_ERROR, _oalString )
    error = staticmethod( error )
    
      
    def abort( _oalString = None ):
        return ALSignal( AL_ACTION_SIGNAL_ABORT, _oalString )
    abort = staticmethod( abort )
    
      
    def exception( _oalString = None ):
        return ALSignal( AL_ACTION_SIGNAL_EXCEPTION, _oalString )
    exception = staticmethod( exception )
    
      
    def exit( _oalString = None ):
        return ALSignal( AL_ACTION_SIGNAL_EXIT, _oalString )
    exit = staticmethod( exit )

    

##############################################################################
