##############################################################################
#
#   File:      al_server_http.py
#
#   Project:   Asynchronous Action Library Project
#              http://aalib.sourceforge.net/
#
#   Author(s): Romeu A. Pieritz & Olof Svensson
#   Contact  : aalib_info@yahoo.com
#
#   Date:      2005/06/24
#
#   License:
#   --------------------------------------------------------------------------
#   Asynchronous Action Library Project
#   Copyright (c) 2005, AALib developers (see above AUTHORS)
#   All rights reserved.
#
#   Redistribution and use in source and binary forms, with or without
#   modification, are permitted provided that the following conditions
#   are met:
#
#   Redistributions of source code must retain the above copyright notice,
#   this list of conditions and the following disclaimer.
#
#   Redistributions in binary form must reproduce the above copyright notice,
#   this list of conditions and the following disclaimer in the documentation
#   and/or other materials provided with the distribution.
#
#   Neither the names of AALib's copyright owner nor the names of its
#   contributors may be used to endorse or promote products derived from
#   this software without specific prior written permission.
#
#   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
#   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
#   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
#   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
#   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
#   TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
#   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
#   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
#   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
#   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
##############################################################################



from al_python               import *
from al_server               import ALServer
from al_handler_request_http import ALHandlerRequestHTTP
from al_string               import ALString


class ALServerHTTP( ALServer ):
    """
    A complete HTTP server. This server can be used as it is for
    asynchronous POST communications. The POST messages are returned
    via the ALManagerSignal callback system.
    
    If you also would like the server to handle synchronous communication
    you must subclass this server and override the "handleRequestSynchronous"
    method. If the request has been handled synchronously a ALMessageResponse
    must be returned by this methd.
    """
    
    
    def __init__( self, _ostrHostName = None, _iPortNumber = None ):
        ALServer.__init__( self )
        ALHandlerRequestHTTP.oalObjectCallBack = self
        self.m_oalStringHostname = ALString( _ostrHostName )
        self.i_PortNumber        = _iPortNumber


    def run( self ):
        if self.m_oalStringHostname is None:
            raise "RunTimeException", "ALServerHTTP: host name is None"
        if self.m_iPortNumber is None:
            raise "RunTimeException", "ALServerHTTP: port number is None"
        self.pyHTTPServer = PyHTTPServer( ( self.m_oalStringHostname, self.m_iPortNumber ), \
            ALHandlerRequestHTTP )
        while True:
            self.pyHTTPServer.handle_request()

    
    def handleRequest( self, _oalMessageCommand ):
        """
        This method must be overridden in subclasses in order to handle
        synchronous HTTP communications.
        """
        return None

    
    def setHostname( self, _ostrHostname ):
        self.m_oalStringHostname = ALString( _ostrHostname )


    def setPortNumber( self, _iPortNumber ):
        self.m_iPortNumber        = _iPortNumber


##############################################################################
