##############################################################################
#
#   File:      al_script_komodo.py
#
#   Project:   Asynchronous Action Library Project
#              http://aalib.sourceforge.net/
#
#   Author(s): Romeu A. Pieritz & Olof Svensson
#   Contact  : aalib_info@yahoo.com
#
#   Date:      2005/06/24
#
#   License:
#   --------------------------------------------------------------------------
#   Asynchronous Action Library Project
#   Copyright (c) 2005, AALib developers (see above AUTHORS)
#   All rights reserved.
#
#   Redistribution and use in source and binary forms, with or without
#   modification, are permitted provided that the following conditions
#   are met:
#
#   Redistributions of source code must retain the above copyright notice,
#   this list of conditions and the following disclaimer.
#
#   Redistributions in binary form must reproduce the above copyright notice,
#   this list of conditions and the following disclaimer in the documentation
#   and/or other materials provided with the distribution.
#
#   Neither the names of AALib's copyright owner nor the names of its
#   contributors may be used to endorse or promote products derived from
#   this software without specific prior written permission.
#
#   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
#   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
#   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
#   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
#   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
#   TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
#   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
#   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
#   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
#   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
##############################################################################


from al_string          import ALString
from al_disk_explorer   import ALDiskExplorer
from al_file            import ALFile
from al_sys             import ALSystem
from al_verbose         import ALVerbose
from al_stream_file     import ALStreamFile
from al_script          import ALScript
from al_stream_xml      import ALStreamXml
from al_xml             import ALXml
from al_xml_node        import ALXmlNode


class ALScriptKomodo( ALScript ):
   
      
    def processFile( self, _oalStrFolder, _oalStrExtension,
                    _oalStrFolderProject, _oalStrFolderTest ):
        oalList =  ALDiskExplorer.getFolderList( _oalStrFolder )
        for ifile in oalList:
            if ALDiskExplorer.isFile( ifile ):
                if ALFile.isExtension( ifile,  _oalStrExtension ):
                    ALVerbose.screen( "FILE:  " + ifile )
                    oalStreamXml = ALStreamXml( ifile, "r" )
                    oalXml = oalStreamXml.input()
                    oalStreamXml.close()
                    
                    self.replaceFolderModule( oalXml, _oalStrFolderProject )
                    self.replaceFolderTest( oalXml, _oalStrFolderTest )
                    
                    #oalStreamXml = ALStreamXml( "teste-teste1.xml" )
                    oalStreamXml = ALStreamXml( ifile )
                    oalStreamXml.output( oalXml )
                    oalStreamXml.close()
                    
                                    
                
        
    def removeFile( self, _oalStrFolder, _oalStrExtension ):
        oalList =  ALDiskExplorer.getFolderList( "../" + _oalStrFolder )
        for ifile in oalList:
            if ALDiskExplorer.isFile( ifile ):
                if ALFile.isExtension( ifile,  _oalStrExtension ):
                    ALDiskExplorer.deleteFile( ifile )
                    ALVerbose.screen( "FILE Deleted:  " + ifile )
                
    
    def replaceFolderModule( self, _oalXml, _oalStrFolderProject ):
       # ALVerbose.screen( "Replacing folder project:  " + _oalStrFolderProject )

        oalAbsolutePath = ALDiskExplorer.absolutePath( ALDiskExplorer.getCurrentFolder() )
        oalAbsolutePath = ALDiskExplorer.addPath( oalAbsolutePath, _oalStrFolderProject )
     
        for inode in _oalXml.getElementsByTagName( "file" ):
            oalXmlNode = inode  
            oalStrFile = ALDiskExplorer.normalize( oalXmlNode.getAttribute( "url" ) )
            if ALFile.isExtension( oalStrFile, ".py" ):
                oalStrFileName = ALFile.getFileName( oalStrFile )
                oalNewName = oalAbsolutePath + "/" + oalStrFileName
                ALVerbose.screen( "Fix:  " + oalNewName )
                oalXmlNode.setAttribute( "url", oalNewName )

        for inode in _oalXml.getElementsByTagName( "string" ):
            oalString = ALString (  inode.getAttribute( "id" ) )
            if oalString=="filename":
                 for jnode in inode.childNodes:
                    if jnode.nodeType==ALXmlNode.TEXT_NODE: 
                        oalStrFile = ALDiskExplorer.normalize( jnode.data )
                        if ALFile.isExtension( oalStrFile, ".py" ):
                            oalStrFileName = ALFile.getFileName( oalStrFile )
                            oalNewName = oalAbsolutePath + "/" + oalStrFileName
                            jnode.data = oalNewName

    
    
    def replaceFolderTest(self, _oalXml, _oalStrFolderTest ):
        # ALVerbose.screen( "Replacing folder test:  " + _oalStrFolderTest )
  
        oalAbsolutePath = ALDiskExplorer.absolutePath( ALDiskExplorer.getCurrentFolder() )
        oalAbsolutePath = ALDiskExplorer.mergePath( oalAbsolutePath, _oalStrFolderTest )
  
        for inode in _oalXml.getElementsByTagName( "string" ):
            oalString = ALString ( inode.getAttribute( "id" ) )
            if oalString=="cwd":
                 for jnode in inode.childNodes:
                    if jnode.nodeType==ALXmlNode.TEXT_NODE: 
                        oalStrFile = ALDiskExplorer.normalize( jnode.data )
                        oalNewName = oalAbsolutePath
                        jnode.data = oalNewName
    
    
    def process( self ):
        self.processFile( "./", ".kpf", "modules", "tests" )
        self.removeFile( "modules", ".pyc" )
     

##############################################################################


if __name__ == '__main__':
     
    oalScript = ALScriptKomodo( "ScriptKomodo" )
    oalScript.execute()


##############################################################################
