##############################################################################
#
#   File:      al_multimethod.py
#
#   Project:   Asynchronous Action Library Project
#              http://aalib.sourceforge.net/
#
#   Author(s): Romeu A. Pieritz & Olof Svensson
#   Contact  : aalib_info@yahoo.com
#
#   Date:      2005/06/24
#
#   License:
#   --------------------------------------------------------------------------
#   Asynchronous Action Library Project
#   Copyright (c) 2005, AALib developers (see above AUTHORS)
#   All rights reserved.
#
#   Redistribution and use in source and binary forms, with or without
#   modification, are permitted provided that the following conditions
#   are met:
#
#   Redistributions of source code must retain the above copyright notice,
#   this list of conditions and the following disclaimer.
#
#   Redistributions in binary form must reproduce the above copyright notice,
#   this list of conditions and the following disclaimer in the documentation
#   and/or other materials provided with the distribution.
#
#   Neither the names of AALib's copyright owner nor the names of its
#   contributors may be used to endorse or promote products derived from
#   this software without specific prior written permission.
#
#   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
#   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
#   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
#   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
#   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
#   TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
#   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
#   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
#   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
#   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
##############################################################################


from al_object  import ALObject
from al_dict    import ALDict


oRegistry = ALDict() #registry = {}


class ALMultiMethod( object, ALObject ):
    
    
    def __init__( self, _name ):
        ALObject.__init__( self ) 
        self.m_name = _name
        self.m_typemap = ALDict()
        
        
    def __call__( self, *_args ):
        types = tuple(arg.__class__ for arg in _args) 
        function = self.m_typemap.get( types )
        if function is None:
            raise TypeError( "no match" )
        return function( *_args )
    
    
    def register( self, _types, _function ):
        if _types in self.m_typemap:
            raise TypeError( "duplicate registration" )
        self.m_typemap[ _types ] = _function



def multimethod( *_types ):
    
    def register( _function ):
        function = getattr( _function, "__lastreg__", _function )
        name = function.__name__
        mm = oRegistry.get(name)
        if mm is None:
            mm = oRegistry[ name ] = ALMultiMethod( name )
        mm.register( _types, function )
        mm.__lastreg__ = function
        return mm
    return register

    
##############################################################################

    
    
    