##############################################################################
#
#   File:      al_message.py
#
#   Project:   Asynchronous Action Library Project
#              http://aalib.sourceforge.net/
#
#   Author(s): Romeu A. Pieritz & Olof Svensson
#   Contact  : aalib_info@yahoo.com
#
#   Date:      2005/06/24
#
#   License:
#   --------------------------------------------------------------------------
#   Asynchronous Action Library Project
#   Copyright (c) 2005, AALib developers (see above AUTHORS)
#   All rights reserved.
#
#   Redistribution and use in source and binary forms, with or without
#   modification, are permitted provided that the following conditions
#   are met:
#
#   Redistributions of source code must retain the above copyright notice,
#   this list of conditions and the following disclaimer.
#
#   Redistributions in binary form must reproduce the above copyright notice,
#   this list of conditions and the following disclaimer in the documentation
#   and/or other materials provided with the distribution.
#
#   Neither the names of AALib's copyright owner nor the names of its
#   contributors may be used to endorse or promote products derived from
#   this software without specific prior written permission.
#
#   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
#   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
#   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
#   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
#   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
#   TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
#   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
#   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
#   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
#   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
##############################################################################



from al_object import ALObject
from al_string import ALString


class ALMessage( ALObject ):
    """
    Base class for message objects.
    """
    
    
    def __init__( self, _oalObject ):
        ALObject.__init__( self )
        self.m_oalObject = None
        if not _oalObject is None:
            if type( _oalObject ) == type( "" ):
                self.m_oalObject = ALString( _oalObject )
            else:
                self.m_oalObject = _oalObject.duplicate()
        self.m_oalStringErrorCode    = None
        self.m_oalStringErrorMessage = None
        
        
    def getMessage( self ):
        """
        @return: A copy of the message object
        """
        value = None
        if not self.m_oalObject is None:
            value = self.m_oalObject.duplicate()
        return value
    
    
    def getErrorCode( self ):
        """
        @return: The error code
        """
        value = None
        if not self.m_oalStringErrorCode is None:
            value = self.m_oalStringErrorCode.duplicate()
        return value
    
    
    def getErrorMessage( self ):
        """
        @return: The error message
        """
        value = None
        if not self.m_oalStringErrorMessage is None:
            value = self.m_oalStringErrorMessage.duplicate()
        return value

  
    def setErrorCode( self, _ostrErrorCode ):
        """
        @param _ostrErrorCode : The error code
        """
        self.m_oalStringErrorCode = ALString( _ostrErrorCode )
    
    
    def setErrorMessage( self, _ostrErrorMessage ):
        """
        @param _ostrErrorMessage : The error message
        """
        self.m_oalStringErrorMessage = ALString( _ostrErrorMessage )   

##############################################################################

    
