##############################################################################
#
#   File:      al_log_file.py
#
#   Project:   Asynchronous Action Library Project
#              http://aalib.sourceforge.net/
#
#   Author(s): Romeu A. Pieritz & Olof Svensson
#   Contact  : aalib_info@yahoo.com
#
#   Date:      2005/06/24
#
#   License:
#   --------------------------------------------------------------------------
#   Asynchronous Action Library Project
#   Copyright (c) 2005, AALib developers (see above AUTHORS)
#   All rights reserved.
#
#   Redistribution and use in source and binary forms, with or without
#   modification, are permitted provided that the following conditions
#   are met:
#
#   Redistributions of source code must retain the above copyright notice,
#   this list of conditions and the following disclaimer.
#
#   Redistributions in binary form must reproduce the above copyright notice,
#   this list of conditions and the following disclaimer in the documentation
#   and/or other materials provided with the distribution.
#
#   Neither the names of AALib's copyright owner nor the names of its
#   contributors may be used to endorse or promote products derived from
#   this software without specific prior written permission.
#
#   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
#   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
#   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
#   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
#   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
#   TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
#   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
#   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
#   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
#   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
##############################################################################


from al_definition          import *
from al_sys                 import ALSystem
from al_log                 import ALLog
from al_string              import ALString
from al_time                import ALTime
from al_stream_file         import ALStreamFile


class ALLogFile( ALLog ):
    """
    Base class to Log output in a file
    This class control the information to log in a file
    """
    m_oalLogFileName = None
    m_bIsInit = None
    
    
    def __init__( self, _oalString = AL_FRAMEWORK_LOG_NAME, _bIsInit = False ):
        ALLog.__init__( self )
        oalStringFilePath = ALSystem.getCurrentFolder()
        oalStringFileName = ALString( oalStringFilePath + ALString( "/" ) + ALString( _oalString ) )      
        ALLogFile.m_oalLogFileName = oalStringFileName
        ALLogFile.m_bIsInit =  _bIsInit      
        if (ALLogFile.m_bIsInit) :
            self.initFile()
       
             
    def initFile( self ):
        if (ALLogFile.m_bIsInit) :
            return
        else:         
            self.synchronizeOn()
            ALLogFile.m_bIsInit = True
            oalLogFile = ALStreamFile( ALLogFile.m_oalLogFileName, "a" )
            oalLogFile.write( "\n\n\n" )
            oalLogFile.write( "##########################################################################\n" )
            oalLogFile.write( "# Asynchronous Action Library Project\n" )
            oalLogFile.write( "# Version   :: " + ALString( AL_VERSION ) + "\n" )
            oalLogFile.write( "# Log File  :: " + ALTime.timeString( ) + "\n" )          
            oalLogFile.write( "# OS        :: " + ALSystem.getOSName() + "\n" )
            oalLogFile.write( "# OSType    :: " + ALSystem.getOSType()  + "\n" )
            oalLogFile.write( "# OSVersion :: " + ALSystem.getOSVersion() + "\n" )
            oalLogFile.write( "# Machine   :: " + ALSystem.getMachineVersion() + "\n" )
            oalLogFile.write( "# Host      :: " + ALSystem.getHost()  + "\n" )
            oalLogFile.write( "# HostIP    :: " + ALSystem.getHostIP()  + "\n" )
            oalLogFile.write( "# UserName  :: " + ALSystem.getUserName()  + "\n" )
            oalLogFile.write( "# Compiler  :: " + ALSystem.getCompilerName()  + "\n" )
            oalLogFile.write( "# Executable:: " + ALSystem.getProgramName()  + "\n" )
            oalLogFile.write( "# ExecFolder:: " + ALSystem.getCwd()  + "\n" )
            oalLogFile.write( "#\n" )                        
            oalLogFile.close()
            self.synchronizeOff()
            
            
    def log( self, _oalString = None ):
        if _oalString != None :
            self.initFile()
        self.synchronizeOn()
        if _oalString != None :
            oalString  = ALString( ALTime.timeString( ) +  _oalString )
            oalLogFile = ALStreamFile( ALLogFile.m_oalLogFileName, "a" )
            oalLogFile.write( oalString )
            oalLogFile.close()
        self.synchronizeOff()
            
            
    def setFileName( self, _oalString ):
        self.synchronizeOn()
        ALLogFile.m_oalLogFileName = ALString( _oalString )
        self.synchronizeOff()
    
    
    def getFileName( self ):
        return ALLogFile.m_oalLogFileName
       
    
##############################################################################

   
   