##############################################################################
#
#   File:      al_handler_request_http.py
#
#   Project:   Asynchronous Action Library Project
#              http://aalib.sourceforge.net/
#
#   Author(s): Romeu A. Pieritz & Olof Svensson
#   Contact  : aalib_info@yahoo.com
#
#   Date:      2005/06/24
#
#   License:
#   --------------------------------------------------------------------------
#   Asynchronous Action Library Project
#   Copyright (c) 2005, AALib developers (see above AUTHORS)
#   All rights reserved.
#
#   Redistribution and use in source and binary forms, with or without
#   modification, are permitted provided that the following conditions
#   are met:
#
#   Redistributions of source code must retain the above copyright notice,
#   this list of conditions and the following disclaimer.
#
#   Redistributions in binary form must reproduce the above copyright notice,
#   this list of conditions and the following disclaimer in the documentation
#   and/or other materials provided with the distribution.
#
#   Neither the names of AALib's copyright owner nor the names of its
#   contributors may be used to endorse or promote products derived from
#   this software without specific prior written permission.
#
#   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
#   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
#   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
#   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
#   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
#   TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
#   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
#   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
#   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
#   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
##############################################################################



from al_string           import ALString
from al_handler_request  import ALHandlerRequest
from al_signal           import ALSignal
from al_manager_signal   import ALManagerSignal
from al_message          import ALMessage
from al_message_command  import ALMessageCommand
from al_python           import *


class ALHandlerRequestHTTP( ALHandlerRequest, PyBaseHTTPRequestHandler ):
    """
    Private class for http requests. This class is designed to be used only
    within the ALServerHTTP class.
    
    """
    
    slObjectCallBack = None
    
    
    def __init__( self, request, client_address, server ):
        ALHandlerRequest.__init__( self )
        PyBaseHTTPRequestHandler.__init__( self, request, client_address, server )


    def do_POST( self ):
        """
        Method overriding the BaseHTTPRequestHandler.do_POST method.
        """
        if ALHandlerRequestHTTP.slObjectCallBack is None:
            self.wfile.write("HTTP/1.1 500 Internal Server Error\n")
        else:
            oslStringPath = ALString( self.path ) 
            if self.headers.getheader("Content-Length") is None:
                raise "RuntimeException", "ALHandlerRequestHTTP: Content-Length is None"
            oslStringContentLength = ALString( self.headers.getheader( "Content-Length" ) )
            iMessageLength    = oslStringContentLength.atoi()
            oslStringMessage  = ALString( self.rfile.read( iMessageLength ) )
            slMessageCommand = ALMessageCommand( oslStringMessage, oslStringPath )
            # Check if the server handles the request synchronously
            slMessageResponseSynchronous = ALHandlerRequestHTTP.slObjectCallBack.handleRequest( slMessageCommand )
            oslStringResponse = slMessageResponseSynchronous.getMessage()
            if slMessageResponseSynchronous.getErrorCode() == "ok":
                self.wfile.write("HTTP/1.1 200 OK\n")
            else:
                self.wfile.write("HTTP/1.1 500 Internal Server Error\n")                
            self.wfile.write( "Content-Type: text/xml\n" )
            self.wfile.write( "Content-Length: %d\n\n"%( len( oslStringResponse ) ) )
            self.wfile.write( oslStringResponse )
            
            
##############################################################################

    
