##############################################################################
#
#   File:      al_file.py
#
#   Project:   Asynchronous Action Library Project
#              http://aalib.sourceforge.net/
#
#   Author(s): Romeu A. Pieritz & Olof Svensson
#   Contact  : aalib_info@yahoo.com
#
#   Date:      2005/06/24
#
#   License:
#   --------------------------------------------------------------------------
#   Asynchronous Action Library Project
#   Copyright (c) 2005, AALib developers (see above AUTHORS)
#   All rights reserved.
#
#   Redistribution and use in source and binary forms, with or without
#   modification, are permitted provided that the following conditions
#   are met:
#
#   Redistributions of source code must retain the above copyright notice,
#   this list of conditions and the following disclaimer.
#
#   Redistributions in binary form must reproduce the above copyright notice,
#   this list of conditions and the following disclaimer in the documentation
#   and/or other materials provided with the distribution.
#
#   Neither the names of AALib's copyright owner nor the names of its
#   contributors may be used to endorse or promote products derived from
#   this software without specific prior written permission.
#
#   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
#   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
#   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
#   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
#   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
#   TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
#   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
#   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
#   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
#   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
##############################################################################



from al_python                  import *
from al_multimethod             import  *
from al_object                  import ALObject
from al_verbose                 import ALVerbose
from al_string                  import ALString
from al_list                    import ALList
from al_disk_explorer           import ALDiskExplorer


     
class ALFile( ALObject ):
    """
    Interface for AL thread objects.
    """
    def __init__( self, _oalString = "None"  ):
        self.setName( ALDiskExplorer.normalize( _oalString ) ) # To change!!!!
       
       
    def exist( _oalString ):
        return PyOS.path.isfile( ALDiskExplorer.normalize( _oalString ) )
    exist = staticmethod( exist )


    def getExtension( _oalString ):
        oalList = ALList( PyOS.path.splitext( ALDiskExplorer.normalize( _oalString ) ) )
        iLenght = len( oalList )
        oalString = ALString( oalList[iLenght-1] )
	return oalString
    getExtension = staticmethod( getExtension )


    def setExtension( _oalStrFile, _oalStrExt ):
        oalList = ALList( PyOS.path.splitext( ALDiskExplorer.normalize( _oalStrFile ) ) )
	oalString2 = ALString()
	for i in range( len( oalList )-1 ):
            oalString2 = oalString2 + ALString( oalList[i] )
	#oalString2 = oalString2 + "." + _oalStrExt
	oalString2 = oalString2 + _oalStrExt
	return oalString2
    setExtension = staticmethod( setExtension )


    def isExtension( _oalStrFileName, _oalStrExtension ):
        #if ALFile.exist( _osStrFileName )==False:
        #    return False
        #
        if ALFile.getExtension( _oalStrFileName )==_oalStrExtension:
            return True
        else:
            return False
    isExtension = staticmethod( isExtension )



    # Dir List + FileName with extension
    def getListName( _oalString ):
        
        oalString = PyOS.path.dirname( _oalString )
        if (oalString == ".." ):
            oalString = ALString( PyOS.getcwd() )
            oalString = ALDiskExplorer.normalize( PyOS.path.dirname( oalString ) )
            oalString = oalString + "/" + ALFile.getFileName( _oalString ) 
        else:
            oalString = ALDiskExplorer.normalize( _oalString )
            
        oalList = ALList( oalString.split( "/" ) )
        return oalList
    getListName = staticmethod( getListName )


    # Without extension
    def getBaseName( _oalString ):
        oalString = ALString( PyOS.path.basename( ALDiskExplorer.normalize( _oalString ) ) )
        oalList = ALList( PyOS.path.splitext( ALDiskExplorer.normalize( oalString ) ) )
	oalString2 = ALString()
	for i in range( len( oalList )-1 ):
            oalString2 = oalString2 + ALString( oalList[i] )
        return oalString2
    getBaseName = staticmethod( getBaseName )


    def getFileName( _oalString ):
        oalString = ALString( PyOS.path.basename( ALDiskExplorer.normalize( _oalString ) ) )
        return oalString
    getFileName = staticmethod( getFileName )

    

    def getFolderName( _oalString ):
        oalString = PyOS.path.dirname( _oalString )
        return oalString
    getFolderName = staticmethod( getFolderName )

    

##############################################################################
