##############################################################################
#
#  File:      sl_com_server.py
#
#  Project:   SciSoft Group Libray Project
#
#  Author(s): Olof Svensson [svensson@esrf.fr]
#             Romeu A. Pieritz [pieritz@esrf.fr]
#
#
#  Date:      2005/05/20
#
#  The SciSoft Group Libray Project is free software; 
#  you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  The SciSoft Group Libray Project is distributed in the hope that 
#  it will be useful, but WITHOUT ANY WARRANTY; without even the implied 
#  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
#  See the GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with the Beamline Simulator; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
#  MA  02111-1307  USA
#
##############################################################################


from sl_system  import *
from sl_com     import SLCom


class SLComServer( SLThread, SLCom ):
    """
    Parent class for all SL server
    communication objects.
    """
    
    
    def __init__( self ):
        SLThread.__init__( self )
        SLCom.__init__( self )
        self.setMagicNumber( "mnSLComServer" )
        
        
    def waitMessage( self, _oslMessage ):
        return None

    
##############################################################################
