##############################################################################
#
#  File:      sl_com_client_http.py
#
#  Project:   SciSoft Group Libray Project
#
#  Author(s): Olof Svensson [svensson@esrf.fr]
#             Romeu A. Pieritz [pieritz@esrf.fr]
#
#
#  Date:      2005/05/20
#
#  The SciSoft Group Libray Project is free software; 
#  you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  The SciSoft Group Libray Project is distributed in the hope that 
#  it will be useful, but WITHOUT ANY WARRANTY; without even the implied 
#  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
#  See the GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with the Beamline Simulator; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
#  MA  02111-1307  USA
#
##############################################################################


from sl_com_client       import SLComClient
from sl_message          import SLMessage
from sl_string           import SLString


class SLComClientHTTP( SLComClient ):
    """
    Parent class for all SL client
    HTTP communication objects.
    """
    
    
    def __init__( self ):
        SLComClient.__init__( self )
        self.m_strHostName = None
        self.m_iPortNumber = None
        
        
    def sendMessageDummy( self, _oesMessage ):
        return None
        
        
    def sendMessage( self, _oslMessageCommand ):

        errorCode    = "ok"
        errorMessage = None

        if self.m_strHostName is None:
            errorCode    = "error"
            errorMessage = "SLComClientHTTP: Host name is None." 
        elif self.m_iPortNumber is None:
            errorCode    = "error"
            errorMessage = "SLComClientHTTP: Port number is None." 

        slMessage    = SLMessage( None )
        strPath      = _oslMessageCommand.getCommand()
        strMessage   = _oslMessageCommand.getMessage()
        
        if errorCode == "ok" :
            try:
                h = SLHTTP( "%s:%d" % ( self.m_strHostName, self.m_iPortNumber ) )
                h.putrequest( "POST",           strPath )
                h.putheader(  "Content-type",   "text/xml" )
                h.putheader(  "Content-length", "%d" % len( strMessage ) )
                h.putheader(  "Accept",         'text/plain' )
                h.putheader(  "Host",           self.m_strHostName )
                h.endheaders( )
                h.send( strMessage )
            except:
                errorCode    = "error"
                errorMessage = "SLComClientHTTP: Send failed." 
                
        reply = None
        msg   = None
        hdrs  = None
        
        if errorCode == "ok" :
            try:        
                reply, msg, hdrs = h.getreply()
            except:
                errorCode    = "error"
                errorMessage = "HTTP client reply failed."
                
        strContentLength = None
        if errorCode == "ok" :
            strContentLength = hdrs.getrawheader( "Content-Length" )
            if strContentLength is None:
                errorCode    = "error" 
                errorMessage = "SLComClientHTTP: No header returned"

        if errorCode == "ok" :
                try:
                    strContentLength = PyString.replace( strContentLength, "\n", "") 
                    iContentLength   = PyString.atoi( strContentLength )
                except:
                    errorCode    = "error"
                    errorMessage = "SLComClientHTTP: Cannot convert Content-Length"

        if errorCode == "ok" :
            try:
                strMessage = h.getfile( ).read( iContentLength )
            except:
                errorCode    = "error"
                errorMessage = "Severe error - cannot read response"
                
        slMessageResponse = SLMessageResponse( strMessage, errorCode, errorMessage )
        return slMessageResponse


##############################################################################
