##############################################################################
#
#   File:      al_action_set_async.py
#
#   Project:   Asynchronous Action Library Project
#              http://aalib.sourceforge.net/
#
#   Author(s): Romeu A. Pieritz & Olof Svensson
#   Contact  : aalib_info@yahoo.com
#
#   Date:      2005/06/24
#
#   License:
#   --------------------------------------------------------------------------
#   Asynchronous Action Library Project
#   Copyright (c) 2005, AALib developers (see above AUTHORS)
#   All rights reserved.
#
#   Redistribution and use in source and binary forms, with or without
#   modification, are permitted provided that the following conditions
#   are met:
#
#   Redistributions of source code must retain the above copyright notice,
#   this list of conditions and the following disclaimer.
#
#   Redistributions in binary form must reproduce the above copyright notice,
#   this list of conditions and the following disclaimer in the documentation
#   and/or other materials provided with the distribution.
#
#   Neither the names of AALib's copyright owner nor the names of its
#   contributors may be used to endorse or promote products derived from
#   this software without specific prior written permission.
#
#   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
#   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
#   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
#   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
#   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
#   TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
#   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
#   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
#   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
#   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
##############################################################################



from al_string              import  ALString
from al_verbose             import  ALVerbose
from al_manager_signal      import  ALManagerSignal
from al_slot                import  ALSlot
from al_signal              import  ALSignal
from al_action_set          import  ALActionSet


class ALActionSetAsynchronous( ALActionSet ):
    """
    Parent class for all AL action set synchronous.
    """ 
    def __init__( self ):
        """
        Constructor for ALActionSetASync.
        
        """
        ALActionSet.__init__( self )
        self.m_bActionSetIsEnded = False
        

    def process( self, _oalObject = None ):
        """
        This is the main method of the action.
        """
        for action in self.m_oalListAction :
            self.threadControl()
            action.execute()  

   
    def addAction( self, _oalAction ):
        """
        Add actions
        """
        ALActionSet.addAction( self, _oalAction )
        self.synchronizeOn()   
        _oalAction.connect( self.endOfActionSet )
        self.synchronizeOff()


    def waitEndOfActionSet( self, _oalObject = None ):
        if not self.m_bActionSetIsEnded:
            self.m_oalThreadingCondition.synchronizeWait()

   
    def endOfActionSet( self, _oalObject = None ):
        self.synchronizeOn()   
        self.m_bActionSetIsEnded = True
        for action in self.m_oalListAction :
            if not action.isEnded():
                self.m_bActionSetIsEnded = False
        self.synchronizeOff()
        if self.m_bActionSetIsEnded:
            self.m_oalThreadingCondition.synchronizeNotify()


############################################################################
# To be modified by the user

    def preProcess( self, _oalObject = None ):
        """
        Any processing that must occur before the action should go into
        this method.
        """
        ALActionSet.preProcess( self )

    def postProcess( self, _oalObject = None ):
        """
        Similar to preProcess, any processing
        """
        ALActionSet.postProcess( self )



##############################################################################

    