##############################################################################
#
#   File:      al_action_set.py
#
#   Project:   Asynchronous Action Library Project
#              http://aalib.sourceforge.net/
#
#   Author(s): Romeu A. Pieritz & Olof Svensson
#   Contact  : aalib_info@yahoo.com
#
#   Date:      2005/06/24
#
#   License:
#   --------------------------------------------------------------------------
#   Asynchronous Action Library Project
#   Copyright (c) 2005, AALib developers (see above AUTHORS)
#   All rights reserved.
#
#   Redistribution and use in source and binary forms, with or without
#   modification, are permitted provided that the following conditions
#   are met:
#
#   Redistributions of source code must retain the above copyright notice,
#   this list of conditions and the following disclaimer.
#
#   Redistributions in binary form must reproduce the above copyright notice,
#   this list of conditions and the following disclaimer in the documentation
#   and/or other materials provided with the distribution.
#
#   Neither the names of AALib's copyright owner nor the names of its
#   contributors may be used to endorse or promote products derived from
#   this software without specific prior written permission.
#
#   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
#   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
#   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
#   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
#   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
#   TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
#   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
#   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
#   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
#   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
##############################################################################


from al_string              import  ALString
from al_verbose             import  ALVerbose
from al_list                import  ALList
from al_manager_signal      import  ALManagerSignal
from al_slot                import  ALSlot
from al_signal              import  ALSignal
from al_action_class        import  ALAction



class ALActionSet( ALAction ):
    """
    Parent class for all action set objects.
    
    NOTE: this class is Synchronous
    """ 
    def __init__( self ):
        """
        Constructor for ALActionSet.
        
        """
        ALAction.__init__( self )
        self.m_oalListAction     = ALList()
        

    
    def addAction( self, _oalAction ):
        """
        Add actions
        """      
        self.synchronizeOn()    
        self.m_oalListAction.append( _oalAction )
        self.m_oalSlotAbort.connect( _oalAction.abort, ALSignal.abort() )
        self.m_oalSlotException.connect( _oalAction.abort, ALSignal.exception() )
        self.synchronizeOff()  

   
    def process( self, _oalObject = None ):
        """
        This is the main method of the action.
        """
        for action in self.m_oalListAction :
            self.threadControl()
            action.execute()
            self.threadControl()
            action.waitActionEnd()  
#            action.waitEndOfAction()       


    def abort( self, _oalObject = None ):
        ALAction.abort( self )
        self.synchronizeOn()    
        for action in self.m_oalListAction :
            action.abort()
        self.synchronizeOff()    


      
    def pause( self, _oalObject = None ):
        ALAction.pause( self )
        self.synchronizeOn()    
        for action in self.m_oalListAction :
            action.pause()
        self.synchronizeOff()    

        
    def resume( self, _oalObject = None ):
        ALAction.resume( self )
        self.synchronizeOn()    
        for action in self.m_oalListAction :
            action.resume()
        self.synchronizeOff()    

        

############################################################################
# To be modified by the user

    def preProcess( self ):
        """
        Any processing that must occur before the action should go into
        this method.
        """
        ALAction.preProcess( self )


    def postProcess( self ):
        """
        Similar to preProcess, any processing
        """
        ALAction.postProcess( self )




##############################################################################

    
