// *****************************************************************************
// Copyright (C) 2000-2005
// CCLRC Daresbury Laboratory, DLS Ltd
// All Rights Reserved.
// *****************************************************************************

package dna.util;

import java.awt.Color;
import java.awt.Component;

import javax.swing.JLabel;
import javax.swing.JTable;

public class StripedLeftRenderer
   extends LeftRenderer
{
   private Color color;
   
   public StripedLeftRenderer(Color color)
   {
      super();
      this.color = color;
   }
   
   public Component getTableCellRendererComponent(JTable table, Object value,
      boolean isSelected, boolean isFocused, int row, int column)
   {
      Component component = super.getTableCellRendererComponent(table, value,
         isSelected, isFocused, row, column);
      if ((row % 2) == 0)
      {
         ((JLabel) component).setBackground(Color.WHITE);
      }
      else
      {
         ((JLabel) component).setBackground(color);
      }
         
      return component;
   }

}
