package dna.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

import dna.observable.IObservableJPanel;

/**
 * A class to create a message output window
 * 
 */
public class MessageOutput
   extends IObservableJPanel
   implements MouseListener
{
   private static JTextArea textOutput = null;
   private static String text = null;
   private static Color color = null;
   private JPopupMenu popup;
   private JScrollPane pane;

   /**
    * Constructor to create a message output window
    * 
    */
   public MessageOutput()
   {
      this("Message Output");
   }

   public MessageOutput(String title)
   {
      pane = new JScrollPane();
      textOutput = new JTextArea(5, 20);
      textOutput.setEditable(false);
      pane.setViewportView(textOutput);

      setLayout(new BorderLayout());
      setBorder(BorderFactory.createTitledBorder(
         BorderFactory.createEtchedBorder(), title, TitledBorder.LEFT,
         TitledBorder.TOP, null, Color.black));
      add(pane, BorderLayout.CENTER);
      popup = createPopup();
      textOutput.addMouseListener(this);
   }

   private JPopupMenu createPopup()
   {
      JMenuItem mi;
      popup = new JPopupMenu("Output");

      mi = popup.add(new JMenuItem("Clear"));
      mi.addActionListener(new ActionListener()
      {
         public void actionPerformed(ActionEvent ev)
         {
            textOutput.setText("");
            notifyIObservers(MessageOutput.this, "Clear");
         }
      });

      return popup;
   }

   // MouseListener interface implementation.

   public void mousePressed(MouseEvent me)
   {
      if (me.isPopupTrigger())
         popup.show(textOutput, me.getPoint().x, me.getPoint().y);
   }

   public void mouseReleased(MouseEvent me)
   {
      if (me.isPopupTrigger())
         popup.show(textOutput, me.getPoint().x, me.getPoint().y);
   }

   public void mouseClicked(MouseEvent me)
   {
      if (me.isPopupTrigger())
         popup.show(textOutput, me.getPoint().x, me.getPoint().y);
   }

   public void mouseEntered(MouseEvent me)
   {
   }

   public void mouseExited(MouseEvent me)
   {
   }

   /**
    * Append text to the text area
    * 
    */
   public static void appendText(String text)
   {
      appendAndScrollToEnd(text);
   }

   public static void appendText(String text, Color color)
   {
      if (textOutput != null)
      {
         Color temp = textOutput.getForeground();
         textOutput.setForeground(color);
         appendAndScrollToEnd(text);
         textOutput.setForeground(temp);
      }
   }

   private static void appendAndScrollToEnd(String text)
   {
      if (textOutput != null)
      {
         textOutput.append(text + "\n");
         textOutput.setCaretPosition(textOutput.getDocument().getLength());
      }
   }

   public static void appendTextLater(String txt)
   {
      text = txt;
      SwingUtilities.invokeLater(new Runnable()
      {
         public void run()
         {
            appendText(text);
         }
      });
   }

   public static void appendTextLater(String txt, Color colour)
   {
      text = txt;
      color = colour;
      SwingUtilities.invokeLater(new Runnable()
      {
         public void run()
         {
            appendText(text, color);
         }
      });
   }

}
