package dna.util;

/**
 * A utility class which allows debugging messages to be inserted and left in
 * code.
 * 
 * Initialise by Debug.check(String level) allowed level strings debug, d1, d2,
 * d3 (check in code). This specifies the debug level which the message must be
 * at (or over) to be printed. Default level is 0 i.e. all message printed. The
 * check method need ONLY BE CALLED ONCE during an application run.
 * 
 * Debug.check("d2");
 * Debug.out("Message 1"); // Always prints
 * Debug.out("Message 2", 1); // Will print
 * Debug.out("Message 3", 2); // Will print
 * Debug.out("Message 3", 3); // Will not print
 * 
 * Can also be used to keep a record of whether running offline using
 * Debug.check("off").
 * 
 */

public class Debug
{
   private static String levels[] =
      {"d0", "debug", "d1", "d2", "d3", "-d0", "-debug", "-d1", "-d2", "-d3"};
   private static int debugLevel = 0;
   private static boolean offline = false;

   public static void check(String[] args)
   {
      for (int i = 0; i < args.length; i++)
      {
         check(args[i]);
      }
   }

   public static void check(String arg)
   {
      int oldLevel = debugLevel;

      for (int i = 0; i < levels.length; i++)
      {
         if (arg.equals(levels[0]))
            debugLevel = 0;
         else if (arg.equals(levels[1]))
            debugLevel = 1;
         else if (arg.equals(levels[2]))
            debugLevel = 1;
         else if (arg.equals(levels[3]))
            debugLevel = 2;
         else if (arg.equals(levels[4]))
            debugLevel = 3;
         if (arg.equals(levels[5]))
            debugLevel = 0;
         else if (arg.equals(levels[6]))
            debugLevel = 1;
         else if (arg.equals(levels[7]))
            debugLevel = 1;
         else if (arg.equals(levels[8]))
            debugLevel = 2;
         else if (arg.equals(levels[9]))
            debugLevel = 3;
         else if (arg.equals("off"))
            offline = true;
      }

      if (debugLevel != oldLevel)
         System.out.println("Debug level set to " + debugLevel);
   }

   public static void out(String message)
   {
      System.out.println(message);
   }

   public static void out(String message, int level)
   {
      if (test(level))
         System.out.println(message);
   }

   public static void out(int level, String message)
   {
      if (test(level))
         System.out.println(message);
   }

   public static boolean isOffline()
   {
      return offline;
   }

   public static boolean isOnline()
   {
      return !offline;
   }

   public static boolean test(int level)
   {
      if (debugLevel >= level)
         return true;
      else
         return false;
   }
}
