package dna.observable;

import java.util.Enumeration;
import java.util.Vector;

public class ObservableComponent
{
   private Vector myIObservers = new Vector();

   public void addIObserver(IObserver anIObserver)
   {
      myIObservers.addElement(anIObserver);
   }

   public void deleteIObserver(IObserver anIObserver)
   {
      myIObservers.removeElement(anIObserver);
   }

   public void deleteIObservers()
   {
      myIObservers.removeAllElements();
   }

   public void notifyIObservers(Object theObserved, Object changeCode)
   {
      Enumeration myIObserversList = myIObservers.elements();
      while (myIObserversList.hasMoreElements())
      {
         IObserver anIObserver = (IObserver) myIObserversList.nextElement();
         anIObserver.update(theObserved, changeCode);
      }
   }
}
