package dna.observable;

import javax.swing.JPanel;

/**
 * A JPanel which implements IObservable. Such JPanels are common in the various
 * GUIs.
 * 
 */

public class IObservableJPanel
   extends JPanel
   implements IObservable
{
   private ObservableComponent oc;

   public IObservableJPanel()
   {
      oc = new ObservableComponent();
   }

   public void addIObserver(IObserver io)
   {
      oc.addIObserver(io);
   }

   public void deleteIObserver(IObserver io)
   {
      oc.deleteIObserver(io);
   }

   public void deleteIObservers()
   {
      oc.deleteIObservers();
   }

   public void notifyIObservers(Object theObserver, Object theArgument)
   {
      oc.notifyIObservers(theObserver, theArgument);
   }
}
