package dna;

import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;

import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class SubmitFeedback
   extends JDialog
   implements DocumentListener
{
   private boolean sendSubmitFeedback = false;
   private JPanel errorPanel;
   private JTextArea errorComment = new JTextArea();
   private JTextField email = new JTextField();
   private JCheckBox[] problemList = null;

   public SubmitFeedback(JComponent jc)
   {
      errorPanel = constructErrorPanel();
      int option = JOptionPane.showOptionDialog(jc.getTopLevelAncestor(),
         errorPanel, "Submit Feedback", JOptionPane.OK_CANCEL_OPTION,
         JOptionPane.INFORMATION_MESSAGE, UIManager.getIcon("informationIcon"),
         new String[]
            {"Ok", "Cancel"}, "Ok");
      switch (option)
      {
         case JOptionPane.CLOSED_OPTION:
            sendSubmitFeedback = false;
            break;
         case 0:
            sendSubmitFeedback = true;
            break;
         case 1:
            sendSubmitFeedback = false;
            break;
      }
      if (sendSubmitFeedback)
      {
         
      }
   }

   private JPanel constructErrorPanel()
   {
      String[] checkBoxLabels =
         {"Indexing failed", "Indexing incorrect", "Strategy incorrect"};

      problemList = new JCheckBox[]
         {new JCheckBox(checkBoxLabels[0]), new JCheckBox(checkBoxLabels[1]),
            new JCheckBox(checkBoxLabels[2])};

      errorPanel = new JPanel();
      GridBagConstraints c = new GridBagConstraints();
      errorPanel.setLayout(new GridBagLayout());
      c.insets = new Insets(2, 0, 0, 0); // Top, Left, Bottom, Right
      c.gridx = 1;
      c.gridy = GridBagConstraints.RELATIVE;
      c.weightx = 1.0;
      c.weighty = 1.0;
      c.fill = GridBagConstraints.BOTH;

      errorPanel.add(new JLabel(
         "Please indicate optional reasons for failure/error.\n"), c);

      for (int i = 0; i < problemList.length; i++)
      {
         problemList[i] = new JCheckBox(checkBoxLabels[i]);
         problemList[i].setName(checkBoxLabels[i]);
         problemList[i].setActionCommand("On");
         problemList[i].setSelected(false);
         errorPanel.add(problemList[i], c);
      }

      errorPanel.add(createTextPanel(), c);

      return errorPanel;
   }

   private JPanel createTextPanel()
   {
      JPanel panel = new JPanel();
      JScrollPane pane = new JScrollPane();

      GridBagConstraints c = new GridBagConstraints();
      panel.setLayout(new GridBagLayout());
      c.insets = new Insets(2, 0, 2, 2); // Top, Left, Bottom, Right
      c.gridx = 1;
      c.gridy = 1;
      c.gridx = GridBagConstraints.RELATIVE;
      c.weightx = 1.0;
      c.weighty = 1.0;
      c.fill = GridBagConstraints.BOTH;
      
      email.getDocument().addDocumentListener(this);
      email.getDocument().putProperty("name", "Email Field");
      errorComment.getDocument().addDocumentListener(this);
      errorComment.getDocument().putProperty("name", "Comment Area");
      errorComment.setRows(8);
      errorComment.setColumns(40);
      errorComment.setFont(new Font("courier", Font.PLAIN, 12));
      pane.setViewportView(errorComment);
      panel.add(new JLabel("Comments: "), c);
      panel.add(pane, c);
      c.gridy++;
      panel.add(new JLabel("Your contact email: "), c);
      panel.add(email, c);
      email.setToolTipText("We may use this to contact you for further information or to give feedback.");

      return panel;
   }

   public void actionPerformed(ActionEvent ae)
   {
   }

   public void changedUpdate(DocumentEvent e)
   {
      // updateLog(e, "changed");
   }

   public void insertUpdate(DocumentEvent e)
   {
      // updateLog(e, "Insert into");
   }

   public void removeUpdate(DocumentEvent e)
   {
      // updateLog(e, "Remove performed");
   }

    public boolean isSubmitFeedbackCreated()
   {
      return sendSubmitFeedback;
   }

   public JCheckBox[] getCheckBoxList()
   {
      return problemList;
   }

   public Document getCommentDocument()
   {
      return errorComment.getDocument();
   }

   public Document getEmailDocument()
   {
      return email.getDocument();
   }
}