package dna;

import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;

import javax.swing.table.AbstractTableModel;

import dna.observable.IObservable;
import dna.observable.IObserver;
import dna.observable.ObservableComponent;

public abstract class StrategyTableModel
   extends AbstractTableModel
   implements Observer, IObservable
{
   private static StrategyTableModel tableModel = null;
   private int maxSequences = 10;
   private ArrayList data = new ArrayList(maxSequences);
   private static int oscillationCount;
   private StrategyData strategyData;

   public abstract boolean isCellEditable(int row, int col);

   private ObservableComponent observableComponent = new ObservableComponent();

   public StrategyTableModel()
   {
      extendStrategyData(0, maxSequences);
      tableModel = this;
   }

   public StrategyData getStrategyData(int index)
   {
      return (StrategyData) data.get(index);
   }

   public static StrategyTableModel getReference()
   {
      return tableModel;
   }

   public void setDataArraySize(int count)
   {
      if (count > maxSequences)
      {
         extendStrategyData(maxSequences, count);
         maxSequences = count;
      }

      oscillationCount = count;
      fireTableDataChanged();
   }

   public int getDataArraySize()
   {
      return oscillationCount;
   }

   private void extendStrategyData(int start, int end)
   {
      for (int i = start; i < end; i++)
      {
         strategyData = new StrategyData();
         strategyData.addObserver(this);
         data.add(strategyData);
      }
   }

   // AbstractTableModel

   public Class getColumnClass(int c)
   {
      return getValueAt(0, c).getClass();
   }

   public int getColumnCount()
   {
      return StrategyData.getColumnCount();
   }

   public int getRowCount()
   {
      return oscillationCount;
   }

   public String getColumnName(int column)
   {
      return StrategyData.getColumnName(column);
   }

   public Object getValueAt(int row, int col)
   {
      Object value = new Double(-1.0);
      strategyData = (StrategyData) data.get(row);

      switch (col)
      {
         case StrategyData.STARTPHI:
            value = strategyData.getStartPhi();
            break;
         case StrategyData.INCREMENT:
            value = strategyData.getIncrement();
            break;
         case StrategyData.OVERLAP:
            value = strategyData.getOverlap();
            break;
         case StrategyData.TIME:
            value = strategyData.getTime();
            break;
         case StrategyData.NIMAGES:
            value = strategyData.getNImages();
            break;
         case StrategyData.PASSES:
            value = strategyData.getPasses();
            break;
         case StrategyData.TEMPLATESTART:
            value = strategyData.getTemplateStart();
            break;
         case StrategyData.RUNNUMBER:
            value = strategyData.getRunNumber();
            break;
         case StrategyData.RESOLUTION:
            value = strategyData.getResolution();
            break;
      }

      return value;
   }

   public void setValueAt(Object value, int row, int col)
   {
      float val;
      if (value != null)
      {
         strategyData = (StrategyData) data.get(row);

         switch (col)
         {
            case StrategyData.STARTPHI:
               strategyData.setStartPhi(new Double(value.toString()));
               break;
            case StrategyData.INCREMENT:
               strategyData.setIncrement(new Double(value.toString()));
               break;
            case StrategyData.OVERLAP:
               strategyData.setOverlap(new Double(value.toString()));
               break;
            case StrategyData.TIME:
               strategyData.setTime(new Double(value.toString()));
               break;
            case StrategyData.NIMAGES:
               val = (new Float(value.toString())).floatValue();
               strategyData.setNImages(new Integer(Math.round(val)));
               break;
            case StrategyData.PASSES:
               val = (new Float(value.toString())).floatValue();
               strategyData.setPasses(new Integer(Math.round(val)));
               break;
            case StrategyData.TEMPLATESTART:
               val = (new Float(value.toString())).floatValue();
               strategyData.setTemplateStart(new Integer(Math.round(val)));
               break;
            case StrategyData.RUNNUMBER:
               val = (new Float(value.toString())).floatValue();
               strategyData.setRunNumber(new Integer(Math.round(val)));
               break;
            case StrategyData.RESOLUTION:
               val = (new Float(value.toString())).floatValue();
               strategyData.setResolution(new Double(value.toString()));
               observableComponent.notifyIObservers(this, new Double(
                  value.toString()));
               break;
         }
      }
   }

   // IObservable

   public void addIObserver(IObserver anIObserver)
   {
      observableComponent.addIObserver(anIObserver);
   }

   public void deleteIObserver(IObserver anIObserver)
   {
      observableComponent.deleteIObserver(anIObserver);
   }

   public void deleteIObservers()
   {
      observableComponent.deleteIObservers();
   }

   // Observer

   public synchronized void update(Observable obs, Object col)
   {
      int i;

      for (i = 0; i < maxSequences; i++)
      {
         if ((StrategyData) obs == (StrategyData) data.get(i))
            break;
      }

      fireTableCellUpdated(i, ((Integer) col).intValue());
   }
}
