package dna;

import java.io.StringReader;
import java.io.StringWriter;

import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;

import dna.util.Debug;
import dna.xml.Strategy_request;
import dna.xml.Strategy_response;

public class StrategyHelper
   implements ExpertListener
{
   protected ExpertClientHTTPServer _httpServer = ExpertClientHTTPServer.getGUIServer();
   protected ExpertProxy _expertProxy = ExpertProxy.getInstance();
   private Strategy_response _strategy_response = null;
   protected String _callbackStatus = "ok";

   public StrategyHelper()
   {
      _httpServer.addExpertListener(this);
   }

   public void sendStrategy_request(Strategy_request strategy_request)
      throws StrategyException
   {
      StringWriter stringWriter = new StringWriter();
      try
      {
         strategy_request.marshal(stringWriter);
         String xml_string = stringWriter.toString();
         Debug.out(xml_string, 2);
         _expertProxy.sendToExpert("/strategy_request", xml_string);
      }
      catch (MarshalException ex)
      {
         throw new StrategyException(
            "MarshalException in StrategyHelper.sendStrategy_request");
      }
      catch (ValidationException ex)
      {
         throw new StrategyException(
            "ValidationException in StrategyHelper.sendStrategy_request");
      }
   }

   public synchronized Strategy_response sendStrategy_requestSynchronous(
      Strategy_request strategy_request, int timeOut) throws StrategyException
   {
      _strategy_response = null;
      _callbackStatus = "ok";
      this.sendStrategy_request(strategy_request);
      Debug.out("Sending strategy request.", 2);
      try
      {
         Debug.out("Strategy request sent, waiting for strategy response.", 2);
         this.wait(timeOut);
      }
      catch (InterruptedException ex)
      {
         throw new StrategyException("InterruptedException caught in "
            + "StrategyHelper.sendStrategy_requestSynchronous");
      }
      if (_strategy_response == null)
         if (_callbackStatus.equals("ok"))
            throw new StrategyException(
               "Time out while waiting for strategy response.");
         else
            throw new StrategyException(_callbackStatus);

      return _strategy_response;
   }

   public synchronized void expertMessage(ExpertXMLMessage the_message)
   {
      String path = the_message.getPath();

      if (path.equals("/strategy_response"))
      {
         String xml_message = the_message.getXMLMessage();
         StringReader reader = new StringReader(the_message.getXMLMessage());

         try
         {
            _strategy_response = (Strategy_response) Unmarshaller.unmarshal(
               Strategy_response.class, reader);
         }
         catch (MarshalException mex)
         {
            Debug.out("MarshallException:" + mex);
            _callbackStatus = "MasrhalException in "
               + "StrategyHelper.expertMessage";
         }
         catch (ValidationException vex)
         {
            Debug.out("ValidationException: " + vex);
            _callbackStatus = "ValidationException in "
               + "StrategyHelper.expertMessage";
         }

         this.notify();
      }
   }
}
