package dna;

import java.util.Observable;

public class StrategyData
   extends Observable
{
   static final int STARTPHI = 0;
   static final int INCREMENT = 1;
   static final int OVERLAP = 2;
   static final int TIME = 3;
   static final int NIMAGES = 4;
   static final int PASSES = 5;
   static final int TEMPLATESTART = 6;
   static final int RUNNUMBER = 7;
   static final int RESOLUTION = 8;
   static final int NUMBER_OF_COLUMNS = 9;

   private static final String COLUMN_NAMES[] =
      {new String("Phi Start"), new String("Increment"), new String("Overlap"),
         new String("Time"), new String("Images"), new String("Passes"),
         new String("1st Image No."), new String("Run Number"),
         new String("Resolution")};

   private Double startPhi = new Double(0.0);
   private Double increment = new Double(0.0);
   private Double overlap = new Double(0.0);
   private Double time = new Double(0.0);
   private Integer nimages = new Integer(0);
   private Integer passes = new Integer(0);
   private Integer templateStart = new Integer(0);
   private Double resolution = new Double(0.0);
   private Integer runNumber = new Integer(0);

   public StrategyData()
   {
   }

   public static int getColumnCount()
   {
      return NUMBER_OF_COLUMNS;
   }

   public static String getColumnName(int column)
   {
      return COLUMN_NAMES[column];
   }

   // Object getters

   public Double getStartPhi()
   {
      return startPhi;
   }

   public Double getIncrement()
   {
      return increment;
   }

   public Double getOverlap()
   {
      return overlap;
   }

   public Double getTime()
   {
      return time;
   }

   public Integer getNImages()
   {
      return nimages;
   }

   public Integer getPasses()
   {
      return passes;
   }

   public Integer getTemplateStart()
   {
      return templateStart;
   }

   public Integer getRunNumber()
   {
      return runNumber;
   }

   public Double getResolution()
   {
      return resolution;
   }

   // Value getters

   public double getValueOfStartPhi()
   {
      return startPhi.doubleValue();
   }

   public double getValueOfIncrement()
   {
      return increment.doubleValue();
   }

   public double getValueOfOverlap()
   {
      return overlap.doubleValue();
   }

   public double getValueOfTime()
   {
      return time.doubleValue();
   }

   public int getValueOfNImages()
   {
      return nimages.intValue();
   }

   public int getValueOfPasses()
   {
      return passes.intValue();
   }

   public int getValueOfTemplateStart()
   {
      return templateStart.intValue();
   }

   public int getValueOfRunNumber()
   {
      return runNumber.intValue();
   }

   public double getValueOfResolution()
   {
      return resolution.doubleValue();
   }

   // Value setters

   public void setStartPhi(double startPhi)
   {
      setStartPhi(new Double(startPhi));
   }

   public void setIncrement(double increment)
   {
      setIncrement(new Double(increment));
   }

   public void setOverlap(double overlap)
   {
      setOverlap(new Double(overlap));
   }

   public void setTime(double time)
   {
      setTime(new Double(time));
   }

   public void setNImages(int nimages)
   {
      setNImages(new Integer(nimages));
   }

   public void setPasses(int passes)
   {
      setPasses(new Integer(passes));
   }

   public void setTemplateStart(int templateStart)
   {
      setTemplateStart(new Integer(templateStart));
   }

   public void setRunNumber(int runNumber)
   {
      setRunNumber(new Integer(runNumber));
   }

   public void setResolution(double resolution)
   {
      setResolution(new Double(resolution));
   }

   // Object setters

   public void setStartPhi(Double startPhi)
   {
      this.startPhi = startPhi;
      setChanged();
      notifyObservers(new Integer(STARTPHI));
   }

   public void setIncrement(Double increment)
   {
      this.increment = increment;
      setChanged();
      notifyObservers(new Integer(INCREMENT));
   }

   public void setOverlap(Double overlap)
   {
      this.overlap = overlap;
      setChanged();
      notifyObservers(new Integer(OVERLAP));
   }

   public void setTime(Double time)
   {
      this.time = time;
      setChanged();
      notifyObservers(new Integer(TIME));
   }

   public void setNImages(Integer nimages)
   {
      this.nimages = nimages;
      setChanged();
      notifyObservers(new Integer(NIMAGES));
   }

   public void setPasses(Integer passes)
   {
      this.passes = passes;
      setChanged();
      notifyObservers(new Integer(PASSES));
   }

   public void setTemplateStart(Integer templateStart)
   {
      this.templateStart = templateStart;
      setChanged();
      notifyObservers(new Integer(TEMPLATESTART));
   }

   public void setRunNumber(Integer runNumber)
   {
      this.runNumber = runNumber;
      setChanged();
      notifyObservers(new Integer(RUNNUMBER));
   }

   public void setResolution(Double resolution)
   {
      this.resolution = resolution;
      setChanged();
      notifyObservers(new Integer(RESOLUTION));
   }

}
