package dna;

import java.io.StringReader;
import java.io.StringWriter;

import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;

import dna.util.Debug;
import dna.xml.Dna_status;
import dna.xml.Dna_status_request;

public class StatusHelper
   implements ExpertListener
{
   private ExpertClientHTTPServer _httpServer = ExpertClientHTTPServer.getGUIServer();
   private ExpertProxy _expertProxy = ExpertProxy.getInstance();
   private Dna_status_request dna_status_request = new Dna_status_request();
   private Dna_status dna_status = null;
   private String callbackStatus = "ok";

   public StatusHelper()
   {
      _httpServer.addExpertListener(this);
   }

   public Dna_status sendDna_status_request() throws StatusException
   {
      Dna_status dna_status = null;

      StringWriter stringWriter = new StringWriter();
      try
      {
         dna_status_request.marshal(stringWriter);
         String xml_string = stringWriter.toString();
         dna_status = (Dna_status) _expertProxy.talkToExpert(
            "/dna_status_request", xml_string);
      }
      catch (MarshalException ex)
      {
         throw new StatusException(
            "MarshalException in StatusHelper.sendDna_status_request");
      }
      catch (ValidationException ex)
      {
         throw new StatusException(
            "ValidationException in StatusHelper.sendDna_status_request");
      }

      if (dna_status == null)
         throw new StatusException("ES Communication Error");

      return dna_status;
   }

   public synchronized Dna_status sendDna_status_requestSynchronous(int timeOut)
      throws StatusException
   {
      dna_status = null;
      callbackStatus = "ok";
      this.sendDna_status_request();

      try
      {
         this.wait(timeOut);
      }
      catch (InterruptedException ex)
      {
         throw new StatusException("InterruptedException caught in "
            + "StatusHelper.sendDna_status_requestSynchronous");
      }

      if (dna_status == null)
      {
         if (callbackStatus.equals("ok"))
            throw new StatusException(
               "Time out while waiting for status response.");
         else
            throw new StatusException(callbackStatus);
      }

      return dna_status;
   }

   public synchronized void expertMessage(ExpertXMLMessage the_message)
   {
      String path = the_message.getPath();

      if (path.equals("/dna_status"))
      {
         String xml_message = the_message.getXMLMessage();
         StringReader reader = new StringReader(the_message.getXMLMessage());

         try
         {
            dna_status = (Dna_status) Unmarshaller.unmarshal(Dna_status.class,
               reader);
         }
         catch (MarshalException mex)
         {
            Debug.out("MarshallException:" + mex);
            callbackStatus = "MasrhalException in "
               + "StatusHelper.expertMessage";
         }
         catch (ValidationException vex)
         {
            Debug.out("ValidationException: " + vex);
            callbackStatus = "ValidationException in "
               + "StatusHelper.expertMessage";
         }

         this.notify();
      }
   }
}
