package dna;

import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;

import javax.swing.table.AbstractTableModel;

/**
 * To change the template for this generated type comment go to Window -
 * Preferences - Java - Code Generation - Code and Comments
 */
public class SessionTableModel
   extends AbstractTableModel
   implements Observer
{
   private static SessionTableModel tableModel = null;
   private int maxSessions = 0;
   private ArrayList data = new ArrayList(maxSessions);
   private static int oscillationCount;
   private SessionData sessionData;
   private int currentSelection;

   public SessionTableModel()
   {
      extendSessionData(0, maxSessions);
      tableModel = this;
   }

   public boolean isCellEditable(int row, int col)
   {
      boolean editable = false;
      if (col == 0)
      {
         editable = true;
      }
         
      return editable;
   }

   public SessionData getSessionData(int index)
   {
      return (SessionData) data.get(index);
   }

   public static SessionTableModel getReference()
   {
      return tableModel;
   }

   public void setDataArraySize(int count)
   {
      if (count > maxSessions)
      {
         extendSessionData(maxSessions, count);
         maxSessions = count;
      }

      oscillationCount = count;
      fireTableDataChanged();
   }

   private void extendSessionData(int start, int end)
   {
      for (int i = start; i < end; i++)
      {
         sessionData = new SessionData();
         sessionData.addObserver(this);
         data.add(sessionData);
      }
   }

   // AbstractTableModel

   public Class getColumnClass(int c)
   {     
      return getValueAt(0, c).getClass();
   }

   public int getColumnCount()
   {
      return SessionData.getColumnCount();
   }

   public int getRowCount()
   {
      return oscillationCount;
   }

   public String getColumnName(int column)
   {
      return SessionData.getColumnName(column);
   }

   public Object getValueAt(int row, int col)
   {
      Object value = new Double(-1.0);
      sessionData = (SessionData) data.get(row);
 
      switch (col)
      {
         case SessionData.SELECT:
            value = sessionData.getSelect();
            if (value == null)
            {
               value = new Boolean( false );
            }
            break;
         case SessionData.START:
            value = sessionData.getStartDate();
            break;
         case SessionData.END:
            value = sessionData.getEndDate();
            break;
         case SessionData.BEAMLINE:
            value = sessionData.getBeamline();
            break;
         case SessionData.COMMENT:
            value = sessionData.getComments();
            break;
      }
      if (value == null)
      {
         value = "empty";
      }

      return value;
   }

   public void setValueAt(Object value, int row, int col)
   {
      float val;
      sessionData = (SessionData) data.get(row);

      switch (col)
      {
         case SessionData.SELECT:
        	Boolean isSelected = (Boolean) value;
            if ( isSelected.booleanValue() == true )
            {
               SessionData sessionDataLast = (SessionData) data.get(currentSelection);
               sessionDataLast.setScreen( new Boolean( false ) );
               currentSelection = row;
            }              
            sessionData.setScreen((Boolean) value);
            break;
         case SessionData.START:
            sessionData.setStartDate((String) value);
            break;
         case SessionData.END:
            sessionData.setEndDate((String) value);
            break;
         case SessionData.BEAMLINE:
            sessionData.setBeamline((String) value);
            break;
         case SessionData.COMMENT:
            sessionData.setComments((String) value);
            break;
      }
   }

   // Observer

   public synchronized void update(Observable obs, Object col)
   {
      int i;

      for (i = 0; i < maxSessions; i++)
      {
         if ((SessionData) obs == (SessionData) data.get(i))
            break;
      }

      fireTableCellUpdated(i, ((Integer) col).intValue());
   }

}
