// *****************************************************************************
// Copyright (C) 2000-2005
// CCLRC Daresbury Laboratory, DLS Ltd
// All Rights Reserved.
// *****************************************************************************

package dna;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

import dna.observable.IObserver;
import dna.util.Debug;
import dna.util.StripedLeftRenderer;
import dna.xml.Loaded_samples_response;

public class SessionPanel
   extends JPanel
   implements MouseListener, IObserver
   {
      private ExpertDataModel edm = ExpertDataModel.getInstance();
      private SessionTableModel sessionTableModel = new SessionTableModel();
      private JTable sessionTable = null;
      private DefaultTableColumnModel sessionColumnModel = new DefaultTableColumnModel();
      private TableColumn column = null;
      private Color lightYellow = new Color(255, 255, 224);
      private StripedLeftRenderer stripeRenderer = new StripedLeftRenderer(lightYellow);
      private Loaded_samples_response samples_response = new Loaded_samples_response();

      public SessionPanel(int sessionCount)
      {
         sessionTable = new JTable(sessionTableModel);
         sessionTable.setAutoCreateColumnsFromModel(false);
         createTableColumnModel(sessionTableModel, sessionColumnModel);
         setDataArraySize(sessionCount);
         setupPanel(sessionTable);
         edm.addIObserver(this);
      }

      private void setupPanel(JTable table)
      {
         setLayout(new BorderLayout());

         table.setPreferredScrollableViewportSize(new Dimension(800, 70));
         table.setDefaultRenderer(String.class, stripeRenderer);
         JScrollPane scrollPane = new JScrollPane(table);

         add(scrollPane, BorderLayout.CENTER);
      }

      private void createTableColumnModel(AbstractTableModel tableModel,
         DefaultTableColumnModel columnModel)
      {
         for (int modelColumnNumber = 0; modelColumnNumber < SessionData.NUMBER_OF_COLUMNS; modelColumnNumber++)
         {
            column = new TableColumn(modelColumnNumber);
            column.setHeaderValue(tableModel.getColumnName(modelColumnNumber));
            switch (modelColumnNumber)
            {
               case SessionData.COMMENT:
                  column.setMinWidth(350);
                  column.setMaxWidth(350);
                  break;
               case SessionData.START:
               case SessionData.END:
               case SessionData.BEAMLINE:
                  column.setMinWidth(160);
                  column.setMaxWidth(160);
                  break;
               case SessionData.SELECT:
                  column.setMinWidth(40);
                  column.setMaxWidth(40);
                  break;
            }
            columnModel.addColumn(column);
         }

         sessionTable.setColumnModel(columnModel);
      }

      public void setDataArraySize(int count)
      {
         sessionTableModel.setDataArraySize(count);
      }

      public int getDataArraySize()
      {
         return sessionTableModel.getRowCount();
      }

      public SessionData getSessionData(int index)
      {
         return sessionTableModel.getSessionData(index);
      }
      
     private void initColumnSizes(JTable table, StrategyTableModel model)
      {
         TableColumn column = null;
         Component comp = null;
         int headerWidth = 0;
         int cellWidth = 0;

         for (int i = 0; i < StrategyData.getColumnCount(); i++)
         {
            column = table.getColumnModel().getColumn(i);

            try
            {
               comp = column.getHeaderRenderer().getTableCellRendererComponent(
                  null, column.getHeaderValue(), false, false, 0, 0);
               headerWidth = comp.getPreferredSize().width;
            }
            catch (NullPointerException e)
            {
            }

            cellWidth = 8;
            column.setPreferredWidth(Math.max(headerWidth, cellWidth));
         }
      }

      // MouseListener

      public void mouseClicked(MouseEvent e)
      {
      }

      public void mouseEntered(MouseEvent e)
      {
      }

      public void mouseExited(MouseEvent e)
      {
         sessionTable.clearSelection();
         sessionTable.editingStopped(new ChangeEvent(this));
      }

      public void mousePressed(MouseEvent e)
      {
      }

      public void mouseReleased(MouseEvent e)
      {
      }

      // IObserver

      public void update(Object iObservable, Object arg)
      {
      }


      public void setSession(int row, String startDate, String endDate, String beamline, 
         String comments)
      {
         SessionData session = sessionTableModel.getSessionData(row);
         session.setStartDate(startDate);
         session.setEndDate(endDate);
         session.setBeamline(beamline);
         session.setComments(comments);
      }
      public boolean isSelected()
      {
         return false;
      }

   }

