package dna;

import java.util.Observable;

public class SessionData
   extends Observable
{
   static final int SELECT = 0;
   static final int START = 1;
   static final int END = 2;
   static final int BEAMLINE = 3;
   static final int COMMENT = 4;
  static final int NUMBER_OF_COLUMNS = 5;

   private static final String COLUMN_NAMES[] =
      {new String("Select"), new String("Start Date"), new String("End Date"),
         new String("Beamline"), new String("Comments")};

   private Boolean select;
   private String startDate = new String();
   private String endDate = new String();
   private String beamline = new String();
   private String comments = new String();

   public SessionData()
   {
   }

   public static int getColumnCount()
   {
      return NUMBER_OF_COLUMNS;
   }

   public static String getColumnName(int column)
   {
      return COLUMN_NAMES[column];
   }

   // Object getters

   public Boolean getSelect()
   {
      return select;
   }

   public String getStartDate()
   {
      return startDate;
   }

   public String getEndDate()
   {
      return endDate;
   }

   public String getBeamline()
   {
      return beamline;
   }

   public String getComments()
   {
      return comments;
   }

   // Object setters

   public void setScreen(Boolean screen)
   {
      this.select = screen;
      setChanged();
      notifyObservers(new Integer(SELECT));
   }

   public void setStartDate(String startDate)
   {
      this.startDate = startDate;
      setChanged();
      notifyObservers(new Integer(START));
   }

   public void setEndDate(String cell)
   {
      this.endDate = cell;
      setChanged();
      notifyObservers(new Integer(END));
   }

   public void setBeamline(String symmetry)
   {
      this.beamline = symmetry;
      setChanged();
      notifyObservers(new Integer(BEAMLINE));
   }

   public void setComments(String resolution)
   {
      this.comments = resolution;
      setChanged();
      notifyObservers(new Integer(COMMENT));
   }

}
